<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EducationDetail extends Model
{
    protected $fillable = [
        'country_of_birth',
        'commune',
        'state',
        'institute_id',
        'passing_year',
        'user_id'
    ];



    /**
     * Get the institute that owns the EducationDetail
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function institute(): BelongsTo
    {
        return $this->belongsTo(Institutions::class, 'institute_id');
    }
}
