@extends('layouts.admin')
@section('content')
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="nk-block-head-content" style="margin-bottom:20px;">
                        <h3 class="nk-block-title page-title">Institutions</h3>

                    </div><!-- .nk-block-head-content -->
                    <div class="nk-block">
                        <div class="card card-bordered card-stretch">
                            <div class="card-aside-wrap">
                                <div class="card-inner card-inner-lg">
                                    @if (permission_access('cards_add') == 1)
                                        <form id="" action="{{ url('admin_school') }}" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <div class="row gy-4">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label class="form-label" for="">Country</label>
                                                        <select id="admin_school_country" class="form-control bfh-countries"
                                                            data-country="" name="country"></select>
                                                        <option value=""></option>
                                                        <span class="text-danger birth_country_message"
                                                            style="display:none">Before going to the next step select
                                                            Country of birth first</span>
                                                    </div>
                                                </div>

                                                <div class="col-md-3 admin_school_commune">
                                                    <div class="form-group">
                                                        <label class="form-label" for="">Commune</label>
                                                        <select id="admin_school_commune" class="form-control bfh-commune"
                                                            name="commune">
                                                            <option value=""></option>
                                                            @foreach ($communes as $commune)
                                                                <option value="{{ $commune->id }}">{{ $commune->commune }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <span class="text-danger birth_commune_message"
                                                            style="display:none">Before going to the next field select
                                                            Commune first</span>
                                                    </div>
                                                </div>

                                                <div class="col-md-3 admin_school_state">
                                                    <div class="form-group">
                                                        <label class="form-label" for="">State/Province</label>
                                                        <select class="form-control bfh-states birth-state-focus"
                                                            data-state="" data-country="admin_school_country"
                                                            name="state"></select>
                                                        <span class="text-danger birth_state_message"
                                                            style="display:none">Before going to the next field select
                                                            State/Province first</span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="form-label">Institution Name:</label>
                                                        <input type="text" class="form-control"
                                                            placeholder="Institution Name" value="" name="name"
                                                            required>
                                                        @if ($errors->any())
                                                            <p style="color: red">{{ $errors->first() }}</p>
                                                        @endif
                                                    </div>
                                                </div>


                                                <div class="col-12">
                                                    <input type="submit" class="btn btn-sm btn-primary" value="Save">
                                                </div>
                                            </div>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="nk-block">
                        <div class="card card-bordered card-stretch">
                            <div class="card-inner-group">
                                <div class="col-md-12">

                                </div>
                                <div class="card-inner">
                                    <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                                        <thead>
                                            <tr class="nk-tb-item nk-tb-head">
                                                <th class="nk-tb-col"><span class="sub-text">Id</span></th>
                                                <th class="nk-tb-col"><span class="sub-text">Institution Name</span></th>
                                                <th class="nk-tb-col"><span class="sub-text">Country</span></th>
                                                <th class="nk-tb-col"><span class="sub-text">State/Commune</span></th>
                                                <th class="nk-tb-col"><span class="sub-text">Status</span></th>
                                                <th class="nk-tb-col tb-col-lg"><span class="sub-text">Action</span></th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
						                  	foreach ($Institutions as $key => $value) {
						                ?>
                                            <tr class="nk-tb-item">
                                                <td class="nk-tb-col">
                                                    <span><?= $key + 1 ?></span>
                                                </td>
                                                <td class="nk-tb-col">
                                                    <span><?= $value->name ?></span>
                                                </td>

                                                <td class="nk-tb-col">
                                                    <span>{{ findCountry($value->country)->name }}</span>
                                                    <input type="hidden" class="hidden_country"
                                                        value="<?= $value->country ?>">
                                                </td>
                                                <td class="nk-tb-col">
                                                    @if ($value->country == 'HT')
                                                        {{ showcommuneName($value->commune) }}
                                                    @else
                                                        {{-- <span class="bfh-states" style="color: #666"
                                                            data-country="{{ $value->country }}"
                                                            data-state="{{ $value->state }}"></span> --}}
                                                        <span>{{ $value->state }}</span>
                                                    @endif
                                                </td>
                                                <td class="nk-tb-col tb-col-md">
                                                    @if ($value->status == 0)
                                                        <span class="text-success">Activated</span>
                                                    @else
                                                        <span class="text-danger">Deactivated</span>
                                                    @endif
                                                </td>
                                                <td class="nk-tb-col tb-col-md">
                                                    @if ($value->status == 0)
                                                        <a data-id="<?= $value->id ?>" data-status="1"
                                                            href="javascript:void(0)"
                                                            data-msg="Are you sure to deactivate this Institute ?"
                                                            class="btn btn-sm btn-info update_institute_status">Deactivate</a>
                                                    @else
                                                        <a data-id="<?= $value->id ?>" data-status="0"
                                                            href="javascript:void(0)"
                                                            data-msg="Are you sure to activate this Institute ?"
                                                            class="btn btn-sm btn-success update_institute_status">Activate</a>
                                                    @endif
                                                    @if (permission_access('cards_edit') == 1)
                                                        <a href="<?php echo url('edit_school'); ?>/<?= $value->id ?>"
                                                            class="btn btn-sm btn-primary">Edit</a>
                                                    @endif
                                                    @if (permission_access('cards_delete') == 1)
                                                        <a href="<?php echo url('delete_school'); ?>/<?= $value->id ?>"
                                                            class="btn btn-sm btn-danger">Delete</a>
                                                    @endif
                                                </td>


                                            </tr>
                                            <?php
											}
										?>

                                        </tbody>
                                    </table>
                                </div>
                            </div><!-- .card-inner-group -->
                        </div><!-- .card -->
                    </div><!-- .nk-block -->


                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            // $(document).on('load', function() {
            // jQuery(function($) {
            // window.onload = function() {
            hidden_country = $('.hidden_country').value();
            console.log('ssss');
            // load countries in bfh-countries
            $('.bfh-countries').bfhcountries({
                country: ''
            });
            $('.bfh-states').bfhstates({
                country: 'country',
                state: ''
            });
            $(".admin_school_commune").hide();
            // hideHaiti();
            // $(".school_commune2").hide();
            // };
        });
        // })(jQuery);
        $(document).on("change", "#admin_school_country", function() {
            haiti = $("#admin_school_country").val();

            if (haiti == "HT") {
                $(".admin_school_commune").show();
                $(".admin_school_state").hide();
            } else {
                $(".admin_school_commune").hide();
                $("#commune").val(0);
                $(".admin_school_state").show();
            }
        })

        function hideHaiti() {
            haiti = $("#admin_school_country").val();
            if (haiti == "HT") {
                $(".admin_school_commune").show();
                $(".admin_school_state").hide();
            } else {
                $(".admin_school_commune").hide();
                // $("#commune").val("");
                $("#commune").val(0);
                $(".admin_school_state").show();
            }
        }
    </script>
@endsection
