<?php
use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
// Route::get('/', function () {
//     return view('main');
// });

Route::get('/clear', function () {
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:cache');
    Artisan::call('route:clear');
});

Route::get('/home', 'HomeController@mainpage')->name('mainpage');
Route::get('/', 'HomeController@mainpage')->name('mainpage');
Route::get('/test', 'HomeController@testmainpage')->name('testmainpage');
Route::get('profile', 'HomeController@profile')->name('profile');
Route::get('chat', 'HomeController@chat')->name('chat');
Route::get('banner', 'HomeController@banner')->name('banner');
Route::get('birthplace', 'HomeController@my_birthplace')->name('birthplace');
Route::get('user_birthplace/{id}', 'HomeController@user_birthplace')->name('user_birthplace');

Route::get('birthplace_list', 'HomeController@my_birthplace_list')->name('birthplace_list');

Route::get('schoolmates', 'HomeController@my_schoolmates')->name('schoolmates');


Route::post('add_user_birthplace_details', 'HomeController@add_user_birthplace_details')->name('add_user_birthplace_details');
Route::post('delete_user_birthplace_details', 'HomeController@delete_user_birthplace_details')->name('delete_user_birthplace_details');
Route::get('edit_user_birthplace_details/{id}', 'HomeController@edit_user_birthplace_details')->name('edit_user_birthplace_details');


Route::get('import_contacts', 'HomeController@import_contacts')->name('import_contacts');
Route::get('appointment_login', 'MainController@appointment_login')->name('appointment_login');
Route::get('user_register', 'MainController@user_register')->name('user_register');
Route::post('register_user', 'MainController@register_user');
Route::get('user_appointment_step1', 'MainController@user_appointment_step1');
Route::post('user_appointment_step2', 'MainController@user_appointment_step2');
Route::get('user_appointment_step2_detail', 'MainController@user_appointment_step2_detail');
Route::post('user_appointment_stepp2', 'MainController@user_appointment_stepp2');
Route::get('user_appointment_stepp2_detail', 'MainController@user_appointment_stepp2_detail');
Route::post('user_appointment_steppp2', 'MainController@user_appointment_steppp2');
Route::get('user_appointment_steppp2_detail', 'MainController@user_appointment_steppp2_detail');
Route::get('user_appointment_step3/{id}', 'MainController@user_appointment_step3');
Route::post('user_appointment_step4_details', 'MainController@user_appointment_step4_details');
Route::get('user_appointment_step4', 'MainController@user_appointment_step4');
Route::get('user_appointment_step5', 'MainController@user_appointment_step5');
Route::post('user_appointment_additional', 'MainController@user_appointment_additional');
Route::get('user_confirm_appointment', 'MainController@user_confirm_appointment');
Route::get('user_final_appointment', 'MainController@user_final_appointment');
Route::get('user_print_appointment', 'MainController@user_print_appointment');
Route::get('user_access_rights', 'HomeController@user_access_rights')->name('user_access_rights');
Route::get('client-survey-records', 'HomeController@client_survey_records')->name('client.survey.records');
Route::get('add_appointment_setting', 'HomeController@add_appointment_setting')->name('add_appointment_setting');
Route::get('block_appointment_date', 'HomeController@block_appointment_date')->name('block_appointment_date');
Route::get('manag_date_settings', 'HomeController@manag_date_settings')->name('manag_date_settings');
Route::get('client_mgmt_setting', 'HomeController@client_mgmt_setting')->name('client_mgmt_setting');
Route::get('email_mgmt_setting', 'HomeController@email_mgmt_setting')->name('email_mgmt_setting');
Route::get('financial_mgmt_setting', 'HomeController@financial_mgmt_setting')->name('financial_mgmt_setting');
Route::get('financial_mgmt_invoice_setup', 'HomeController@financial_mgmt_invoice_setup')->name('financial_mgmt_invoice_setup');
Route::get('financial_mgmt_choose_template', 'HomeController@financial_mgmt_choose_template')->name('financial_mgmt_choose_template');
Route::get('balancesheet_template1', 'HomeController@balancesheet_template1')->name('balancesheet_template1');
Route::get('manage_clients', 'HomeController@manage_clients')->name('manage_clients');
Route::get('client_list', 'HomeController@client_list')->name('client_list');
Route::get('view_client_profiles', 'HomeController@view_client_profiles')->name('view_client_profiles');
Route::get('appointment_step3/{id}', 'HomeController@appointment_step3')->name('appointment_step3');
Route::post('appointment_step2', 'HomeController@appointment_step2');
Route::post('appointment_stepp2', 'HomeController@appointment_stepp2');
Route::post('appointment_steppp2', 'HomeController@appointment_steppp2');
Route::get('appointment_step1', 'HomeController@appointment_step1')->name('appointment_step1');
Route::get('appointment_step4', 'HomeController@appointment_step4')->name('appointment_step4');
Route::get('appointment_step5', 'HomeController@appointment_step5')->name('appointment_step5');
Route::get('confirm_appointment', 'HomeController@confirm_appointment')->name('confirm_appointment');
Route::get('print_appointment', 'HomeController@print_appointment')->name('print_appointment');
Route::get('add_client', 'HomeController@add_client')->name('add_client');
Route::get('balancesheet_template2', 'HomeController@balancesheet_template2')->name('balancesheet_template2');
Route::get('balancesheet_settings', 'HomeController@balancesheet_settings')->name('balancesheet_settings');
Route::get('create_expense_account', 'HomeController@create_expense_account')->name('create_expense_account');
Route::get('create_revenue_account', 'HomeController@create_revenue_account')->name('create_revenue_account');
Route::get('invoice_setup', 'HomeController@invoice_setup')->name('invoice_setup');
Route::get('client_access', 'HomeController@client_access')->name('client_access');
Route::get('chart_account', 'HomeController@chart_account')->name('chart_account');
Route::get('templates', 'HomeController@templates')->name('templates');
Route::get('setting_tutorials', 'HomeController@setting_tutorials')->name('setting_tutorials');
// Route::get('setting_birthplace', 'HomeController@setting_birthplace')->name('setting_birthplace');

Route::get('profile_info', 'HomeController@profile_info')->name('profile_info');
Route::get('tasks', 'HomeController@tasks')->name('tasks');
Route::get('forms_library', 'HomeController@forms_library')->name('forms_library');
Route::get('change_appointment', 'HomeController@change_appointment')->name('change_appointment');
Route::get('cancel_appointment', 'HomeController@cancel_appointment')->name('cancel_appointment');
Route::get('comparison_appointment', 'HomeController@comparison_appointment')->name('comparison_appointment');
Route::get('manage_appointment', 'HomeController@manage_appointment')->name('manage_appointment');
Route::get('appointment_tutorials', 'HomeController@appointment_tutorials')->name('appointment_tutorials');
Route::get('schedule_birthday', 'HomeController@schedule_birthday')->name('schedule_birthday');
Route::get('schedule_holiday', 'HomeController@schedule_holiday')->name('schedule_holiday');
Route::get('view_holiday', 'HomeController@view_holiday')->name('view_holiday');
Route::get('view_birthday', 'HomeController@view_birthday')->name('view_birthday');
Route::get('comparison_client', 'HomeController@comparison_client')->name('comparison_client');
Route::get('client_tutorials', 'HomeController@client_tutorials')->name('client_tutorials');
Route::get('email_campaign', 'HomeController@email_campaign')->name('email_campaign');
Route::get('send_email/{id}', 'HomeController@send_email');
Route::get('send_email', 'HomeController@send_email')->name('send_email');
Route::get('send_cards', 'HomeController@send_cards')->name('send_cards');
Route::get('send_video', 'HomeController@send_video')->name('send_video');
Route::get('send_sms', 'HomeController@send_sms')->name('send_sms');
Route::get('test_send_sms', 'HomeController@test_send_sms');
Route::get('comparison_email', 'HomeController@comparison_email')->name('comparison_email');
Route::get('comparison_email2', 'HomeController@comparison_email2');
Route::get('comparison_email3', 'HomeController@comparison_email3');
Route::get('manage_folders', 'HomeController@manage_folders')->name('manage_folders');
Route::get('manage_contacts', 'HomeController@manage_contacts')->name('manage_contacts');
Route::get('manage_emails', 'HomeController@manage_emails')->name('manage_emails');
Route::get('uploads', 'HomeController@uploads')->name('uploads');
Route::get('email_tutorials', 'HomeController@email_tutorials')->name('email_tutorials');
Route::get('revenue_records', 'HomeController@revenue_records')->name('revenue_records');
Route::get('revenue_records_neg', 'HomeController@revenue_records_neg')->name('revenue_records_neg');
Route::get('revenue_records_pos', 'HomeController@revenue_records_pos')->name('revenue_records_pos');

Route::get('expenses_reord', 'HomeController@expenses_reord')->name('expenses_reord');
Route::get('manage_assets', 'HomeController@manage_assets')->name('manage_assets');
Route::get('balancesheet', 'HomeController@balancesheet')->name('balancesheet');
Route::get('create_budget', 'HomeController@create_budget')->name('create_budget');
Route::get('tab2', 'HomeController@tab2')->name('tab2');
Route::get('tab3', 'HomeController@tab3')->name('tab3');
Route::get('tab4', 'HomeController@tab4')->name('tab4');
Route::get('tab5', 'HomeController@tab5')->name('tab5');
Route::get('create_projection', 'HomeController@create_projection')->name('create_projection');
Route::get('tab22', 'HomeController@tab22')->name('tab22');
Route::get('tab33', 'HomeController@tab33')->name('tab33');
Route::get('tab44', 'HomeController@tab44')->name('tab44');
Route::get('tab55', 'HomeController@tab55')->name('tab55');
Route::get('profit_loss_stmt', 'HomeController@profit_loss_stmt')->name('profit_loss_stmt');
Route::get('revenue_report', 'HomeController@revenue_report')->name('revenue_report');
Route::get('expenses_report', 'HomeController@expenses_report')->name('expenses_report');
Route::get('comparison_finance', 'HomeController@comparison_finance')->name('comparison_finance');
Route::get('financial_tutorials', 'HomeController@financial_tutorials')->name('financial_tutorials');
Route::get('edit_archives', 'HomeController@edit_archives')->name('edit_archives');
Route::get('delete_archives', 'HomeController@delete_archives')->name('delete_archives');
Route::get('appointment_archives', 'HomeController@appointment_archives')->name('appointment_archives');
Route::get('financial_archives', 'HomeController@financial_archives')->name('financial_archives');
Route::get('client_archives', 'HomeController@client_archives')->name('client_archives');
Route::get('email_archives', 'HomeController@email_archives')->name('email_archives');
Route::get('comparison-tab1', 'HomeController@comparisontab1')->name('comparisontab1');
Route::get('comparison-tab2', 'HomeController@comparisontab2')->name('comparisontab2');
Route::get('comparison-tab3', 'HomeController@comparisontab3')->name('comparisontab3');
Route::get('comparison-tab4', 'HomeController@comparisontab4')->name('comparisontab4');
Route::get('archives_tutorials', 'HomeController@archives_tutorials')->name('archives_tutorials');
Route::post('update_language', 'AdminController@update_language');
Route::post('codeavailability', 'AdminController@codeavailability');
Route::post('emailavailability', 'AdminController@emailavailability');
Route::post('adcodeavailability', 'HomeController@codeavailability');
Route::post('ademailavailability', 'HomeController@emailavailability');
Route::get('register_business', 'HomeController@register_business');
Route::post('registration_business', 'HomeController@registration_business');
Route::post('businessemailavailability', 'HomeController@businessemailavailability');
Route::post('create_budget_monthly', 'HomeController@create_budget_monthly');
Route::post('create_budget_quarterly', 'HomeController@create_budget_quarterly');
Route::post('create_expense_quarterly', 'HomeController@create_expense_quarterly');
Route::post('create_expense_monthly', 'HomeController@create_expense_monthly');
Route::post('create_projection_expense_monthly', 'HomeController@create_projection_expense_monthly');
Route::post('create_projection_monthly', 'HomeController@create_projection_monthly');
Route::post('create_projection_quarterly', 'HomeController@create_projection_quarterly');
Route::post('expense_projection_monthly', 'HomeController@expense_projection_monthly');
Route::post('expense_projection_quarterly', 'HomeController@expense_projection_quarterly');
Route::post('email_campaign_send_on', 'HomeController@email_campaign_send_on');
Route::post('emmail_prev_details', 'HomeController@emmail_prev_details');
Route::post('sms_prev_details', 'HomeController@sms_prev_details');
Route::post('title_wise_email', 'HomeController@title_wise_email');
Route::post('banner_submit', 'HomeController@banner_submit');
Route::post('image_up_banner', 'HomeController@image_up_banner');
Route::post('email_campaign_send_with_reminder', 'HomeController@email_campaign_send_with_reminder');
Route::post('popup_mail', 'HomeController@popup_mail');
Route::post('popup_mail_date', 'HomeController@popup_mail_date');
Route::post('uncheckboxesmail', 'HomeController@uncheckboxesmail');
Route::post('uncheckedboxesmail', 'HomeController@uncheckedboxesmail');
Route::post('manage_client_submit', 'HomeController@manage_client_submit');
Route::post('user_banner_details', 'HomeController@user_banner_details');
Route::post('manage_client_send_on', 'HomeController@manage_client_send_on');
Route::post('manage_client_send_with_reminder', 'HomeController@manage_client_send_with_reminder');
Route::post('manage_client_card_submit', 'HomeController@manage_client_card_submit');
Route::post('manage_client_card_send_on', 'HomeController@manage_client_card_send_on');
Route::post('manage_client_card_send_with_reminder', 'HomeController@manage_client_card_send_with_reminder');
Route::post('manage_client_video_submit', 'HomeController@manage_client_video_submit');
Route::post('manage_client_video_send_on', 'HomeController@manage_client_video_send_on');
Route::post('manage_client_video_send_with_reminder', 'HomeController@manage_client_video_send_with_reminder');
Route::post('view_clientf', 'HomeController@view_clientf');
Route::post('schedule_birthday_submit', 'HomeController@schedule_birthday_submit');
Route::post('schedule_birthday_card_submit', 'HomeController@schedule_birthday_card_submit');
Route::post('schedule_birthday_video_submit', 'HomeController@schedule_birthday_video_submit');
Route::post('holiday_details', 'HomeController@holiday_details');
Route::post('schedule_holiday_submit', 'HomeController@schedule_holiday_submit');
Route::post('schedule_holiday_card_submit', 'HomeController@schedule_holiday_card_submit');
Route::post('schedule_holiday_video_submit', "HomeController@schedule_holiday_video_submit");
Route::get('comparison_client', 'HomeController@comparison_client');
Route::post('revenue_account_submit', 'HomeController@revenue_account_submit');
Route::post('edit_revenue_aacount', 'HomeController@edit_revenue_aacount');
Route::post('revenue_account_update', 'HomeController@revenue_account_update');
Route::post('delete_revenue_aacount', 'HomeController@delete_revenue_aacount');
Route::post('delete_revenue_aacount_post', 'HomeController@delete_revenue_aacount_post');
Route::post('expenses_account_submit', 'HomeController@expenses_account_submit');
Route::post('edit_expenses_aacount', 'HomeController@edit_expenses_aacount');
Route::post('expenses_account_update', 'HomeController@expenses_account_update');
Route::post('delete_expenses_aacount', 'HomeController@delete_expenses_aacount');
Route::post('delete_expenses_aacount_post', 'HomeController@delete_expenses_aacount_post');
Route::post('delete_balancesheet_settings_account_post', 'HomeController@delete_balancesheet_settings_account_post');
Route::get('financial_mgmt_expenses_settings', 'HomeController@financial_mgmt_expenses_settings');
Route::post('create_budget_names', 'HomeController@create_budget_names');
Route::post('create_projection_names', 'HomeController@create_projection_names');
Route::post('create_quarterlybudget_names', 'HomeController@create_quarterlybudget_names');
Route::post('create_expenses_names', 'HomeController@create_expenses_names');
Route::post('create_projection_expenses_names', 'HomeController@create_projection_expenses_names');
Route::post('create_quarterlyprojection_names', 'HomeController@create_quarterlyprojection_names');
Route::post('create_projection_quarterlyexpenses_names', 'HomeController@create_projection_quarterlyexpenses_names');
Route::post('create_quarterlyexpenses_names', 'HomeController@create_quarterlyexpenses_names');
Route::get('calender_meeting', 'HomeController@calender_meeting');
Route::get('calendarcheck', 'HomeController@calendarcheck');
Route::post('addevents', 'HomeController@addevents');
Route::get('chart', 'HomeController@chart');
Route::post('getgraph', 'HomeController@getgraph');
Route::post('getgraph2', 'HomeController@getgraph2');
Route::post('getgraphexp', 'HomeController@getgraphexp');
Route::post('getgraphproexp', 'HomeController@getgraphproexp');
Route::post('getremovedgraph', 'HomeController@getremovedgraph');
Route::post('getquarrterlygraph', 'HomeController@getquarrterlygraph');
Route::post('getquarrterlygraph2', 'HomeController@getquarrterlygraph2');
Route::post('getquarrterlygraphexp', 'HomeController@getquarrterlygraphexp');
Route::post('getremovedgraphquarterly', 'HomeController@getremovedgraphquarterly');
Route::get('add_user_access_rights', 'HomeController@add_user_access_rights');
Route::post('add_user_access', 'HomeController@add_user_access');
Route::get('edit_user_access_rights/{id}', 'HomeController@edit_user_access_rights');
Route::post('edit_user_access', 'HomeController@edit_user_access');
Route::get('delete_user_access_rights/{id}', 'HomeController@delete_user_access_rights');
Route::get('view_access_roles/{id}', 'HomeController@view_access_roles');
Route::post('import_contact_entry', 'HomeController@import_contact_entry');
Route::post('block_appointment_entry', 'HomeController@block_appointment_entry');
Route::post('checkblockdate', 'HomeController@checkblockdate');
Route::get('delete_block_date/{id}', 'HomeController@delete_block_date');
Route::post('appointment_setting_entry', 'HomeController@appointment_setting_entry');
Route::post('appointment_setting_update', 'HomeController@appointment_setting_update');
Route::post('revenue_records_submit', 'HomeController@revenue_records_submit');
Route::post('get_client_details', 'HomeController@get_client_details');
Route::get('edit_revenue_record/{id}', 'HomeController@edit_revenue_record');
Route::post('revenue_records_update', 'HomeController@revenue_records_update');
Route::get('up_revenue_record', 'HomeController@up_revenue_record');
Route::post('client_revenue_list', 'HomeController@client_revenue_list');
Route::post('client_revenue_list_pos', 'HomeController@client_revenue_list_pos');
Route::post('client_revenue_list_neg', 'HomeController@client_revenue_list_neg');
Route::post('get_invoice_list', 'HomeController@get_invoice_list');
Route::post('get_invoice_amount', 'HomeController@get_invoice_amount');
Route::get('monthly_budget_chart/{id}', 'HomeController@monthly_budget_chart');
Route::get('monthly_expense_chart/{id}', 'HomeController@monthly_expense_chart');
Route::get('total_monthly_budget_chart', 'HomeController@total_monthly_budget_chart');
Route::get('quarterly_budget_chart/{id}', 'HomeController@quarterly_budget_chart');
Route::get('quarterly_expense_chart/{id}', 'HomeController@quarterly_expense_chart');
Route::get('total_quarterly_budget_chart', 'HomeController@total_quarterly_budget_chart');
Route::get('total_quarterly_expense_chart', 'HomeController@total_quarterly_expense_chart');
Route::get('revenue_variance_monthly_graph/{id}', 'HomeController@revenue_variance_monthly_graph');
Route::get('revenue_variance_quarterly_graph/{id}', 'HomeController@revenue_variance_quarterly_graph');
Route::get('revenue_variance_quarterly_graph2/{id}', 'HomeController@revenue_variance_quarterly_graph2');
Route::get('expense_variance_monthly_graph/{id}', 'HomeController@expense_variance_monthly_graph');
Route::get('expense_variance_quarterly_graph/{id}', 'HomeController@expense_variance_quarterly_graph');
Route::get('expense_variance_quarterly_graph2/{id}', 'HomeController@expense_variance_quarterly_graph2');
Route::get('monthly_projection_chart/{id}', 'HomeController@monthly_projection_chart');
Route::get('total_monthly_projection_chart', 'HomeController@total_monthly_projection_chart');
Route::get('total_monthly_projectionexp_chart', 'HomeController@total_monthly_projectionexp_chart');
Route::get('quarterly_projection_chart/{id}', 'HomeController@quarterly_projection_chart');
Route::get('quarterly_projectionexp_chart/{id}', 'HomeController@quarterly_projectionexp_chart');
Route::get('total_quarterly_projection_chart', 'HomeController@total_quarterly_projection_chart');
Route::get('total_quarterly_projectionexp_chart', 'HomeController@total_quarterly_projectionexp_chart');
Route::get('revenue_variance_monthly_graph2/{id}', 'HomeController@revenue_variance_monthly_graph2');
Route::get('expense_variance_monthly_graph2/{id}', 'HomeController@expense_variance_monthly_graph2');
Route::get('projection_monthly_vary_chart', 'HomeController@projection_monthly_vary_chart');
Route::get('projectionexp_monthly_vary_chart', 'HomeController@projectionexp_monthly_vary_chart');
Route::get('revenue_monthly_vary_chart', 'HomeController@revenue_monthly_vary_chart');
Route::get('revenue_quarterly_vary_chart', 'HomeController@revenue_quarterly_vary_chart');
Route::get('revenue_quarterly_vary_chart2', 'HomeController@revenue_quarterly_vary_chart2');
Route::post('expense_records_submit', 'HomeController@expense_records_submit');
Route::get('edit_expense_record/{id}', 'HomeController@edit_expense_record');
Route::post('expense_record_update', 'HomeController@expense_record_update');
Route::get('total_monthly_expense_chart', 'HomeController@total_monthly_expense_chart');
Route::get('expense_monthly_vary_chart', 'HomeController@expense_monthly_vary_chart');
Route::get('expense_monthly_vary_items', 'HomeController@expense_monthly_vary_items');
Route::get('expense_quarterly_vary_chart', 'HomeController@expense_quarterly_vary_chart');
Route::get('expense_quarterly_vary_chart2', 'HomeController@expense_quarterly_vary_chart2');
Route::get('monthly_projectionexp_chart/{id}', 'HomeController@monthly_projectionexp_chart');
Route::post('getquarrterlygraphproexp', 'HomeController@getquarrterlygraphproexp');
Route::get('gross_revenue_chart', 'HomeController@gross_revenue_chart');
Route::get('gross_quarter_revenue_chart', 'HomeController@gross_quarter_revenue_chart');

Route::get('gross_quarter_revenue_chart2', 'HomeController@gross_quarter_revenue_chart2');
Route::get('other_revenue_chart', 'HomeController@other_revenue_chart');
Route::get('other_quarter_revenue_chart', 'HomeController@other_quarter_revenue_chart');
Route::get('other_quarter_revenue_chart2', 'HomeController@other_quarter_revenue_chart2');
Route::get('all_revenue_chart', 'HomeController@all_revenue_chart');
Route::get('est_chart', 'HomeController@est_chart');
Route::get('all_quarter_revenue_chart', 'HomeController@all_quarter_revenue_chart');
Route::get('all_quarter_revenue_chart2', 'HomeController@all_quarter_revenue_chart2');
Route::get('gross_revenue_chart2', 'HomeController@gross_revenue_chart2');
Route::get('other_revenue_chart2', 'HomeController@other_revenue_chart2');
Route::get('all_revenue_chart2', 'HomeController@all_revenue_chart2');
Route::post('asset_records_submit', 'HomeController@asset_records_submit');
Route::post('manage_assets_delete', 'HomeController@manage_assets_delete');
Route::get('manage_assets_edit/{id}', 'HomeController@manage_assets_edit');
Route::get('up_assets_edit', 'HomeController@up_assets_edit');
Route::post('asset_records_update', 'HomeController@asset_records_update');
Route::get('monthly_email_campaign_chart', 'HomeController@monthly_email_campaign_chart');
Route::get('monthly_send_email_chart', 'HomeController@monthly_send_email_chart');
Route::get('monthly_send_card_chart', 'HomeController@monthly_send_card_chart');
Route::get('monthly_send_video_chart', 'HomeController@monthly_send_video_chart');
Route::get('monthly_send_sms_chart', 'HomeController@monthly_send_sms_chart');
Route::get('monthly_email_campaign_chartt/{id}', 'HomeController@monthly_email_campaign_chartt');
Route::get('monthly_send_email_chartt/{id}', 'HomeController@monthly_send_email_chartt');
Route::get('monthly_send_card_chartt/{id}', 'HomeController@monthly_send_card_chartt');
Route::get('monthly_send_video_chartt/{id}', 'HomeController@monthly_send_video_chartt');
Route::get('monthly_send_sms_chartt/{id}', 'HomeController@monthly_send_sms_chartt');
Route::get('monthly_profit_loss_chart', 'HomeController@monthly_profit_loss_chart');
Route::get('quarterly_profit_loss_chart', 'HomeController@quarterly_profit_loss_chart');
// Route::post('appointment_step2', 'HomeController@appointment_step2');
Route::get('appointment_step2_detail', 'HomeController@appointment_step2_detail');
Route::get('appointment_stepp2_detail', 'HomeController@appointment_stepp2_detail');
Route::get('appointment_steppp2_detail', 'HomeController@appointment_steppp2_detail');
Route::post('appointment_email_send', 'HomeController@appointment_email_send');
Route::post('appointmentstepdet', 'HomeController@appointmentstepdet');
Route::post('appointment_date_availabilityy', 'HomeController@appointment_date_availabilityy');
Route::post('appointment_step4_details', 'HomeController@appointment_step4_details');
Route::post('appointment_additional', 'HomeController@appointment_additional');
Route::get('final_appointment', 'HomeController@final_appointment');
Route::get('change_appointment_step/{id}', 'HomeController@change_appointment_step');
Route::get('change_appointment_view/{id}', 'HomeController@change_appointment_view');
Route::post('delete_appointment', 'HomeController@delete_appointment');
Route::get('monthly_client_appointment_chartt/{id}', 'HomeController@monthly_client_appointment_chartt');
Route::get('monthly_new_appointment_chartt/{id}', 'HomeController@monthly_new_appointment_chartt');
Route::get('monthly_change_appointment_chartt/{id}', 'HomeController@monthly_change_appointment_chartt');
Route::post('monthlylistappointment', 'HomeController@monthlylistappointment');
Route::post('monthlyrevenuelistappointment', 'HomeController@monthlyrevenuelistappointment');
Route::post('monthlyexpenseslistappointment', 'HomeController@monthlyexpenseslistappointment');
Route::post('monthlyassetlistappointment', 'HomeController@monthlyassetlistappointment');
Route::post('monthlyrevenuelistappointmentt', 'HomeController@monthlyrevenuelistappointmentt');
Route::post('monthlyexpenseslistappointmentt', 'HomeController@monthlyexpenseslistappointmentt');
Route::post('monthlyassetlistappointmentt', 'HomeController@monthlyassetlistappointmentt');
Route::post('quarterlylistappointment', 'HomeController@quarterlylistappointment');
Route::post('contactwisemailll', 'HomeController@contactwisemailll');
Route::post('delete_revenue_record', 'HomeController@delete_revenue_record');
Route::post('delete_expense_record', 'HomeController@delete_expense_record');
Route::get('monthly_asset_chartt/{desc}', 'HomeController@monthly_asset_chartt');
//Route::get('affiliate_registration/{user_id}/{code}', 'HomeController@affiliate_registration');
Route::post('record_revenue_month_details', 'HomeController@record_revenue_month_details');
Route::post('total_record_revenue_month_details', 'HomeController@total_record_revenue_month_details');
Route::post('record_expense_month_details', 'HomeController@record_expense_month_details');
Route::post('total_record_expense_month_details', 'HomeController@total_record_expense_month_details');
Route::post('record_asset_month_details', 'HomeController@record_asset_month_details');
Route::post('total_record_asset_month_details', 'HomeController@total_record_asset_month_details');
Route::post('record_revenue_delete_month_details', 'HomeController@record_revenue_delete_month_details');
Route::post('total_record_revenue_delete_month_details', 'HomeController@total_record_revenue_delete_month_details');
Route::post('record_expense_delete_month_details', 'HomeController@record_expense_delete_month_details');
Route::post('total_record_expense_delete_month_details', 'HomeController@total_record_expense_delete_month_details');
Route::post('record_asset_delete_month_details', 'HomeController@record_asset_delete_month_details');
Route::post('total_record_asset_delete_month_details', 'HomeController@total_record_asset_delete_month_details');
Route::post('new_clients_details', 'HomeController@new_clients_details');
Route::post('total_clients_details', 'HomeController@total_clients_details');
Route::post('new_appointment_details', 'HomeController@new_appointment_details');
Route::post('total_new_appointment_details', 'HomeController@total_new_appointment_details');
Route::post('change_appointment_details', 'HomeController@change_appointment_details');
Route::post('total_change_appointment_details', 'HomeController@total_change_appointment_details');
Route::post('cancel_appointment_details', 'HomeController@cancel_appointment_details');
Route::post('total_cancel_appointment_details', 'HomeController@total_cancel_appointment_details');
Route::post('new_clients_detailsq', 'HomeController@new_clients_detailsq');
Route::post('new_appointment_detailsq', 'HomeController@new_appointment_detailsq');
Route::post('change_appointment_detailsq', 'HomeController@change_appointment_detailsq');
Route::post('cancel_appointment_detailsq', 'HomeController@cancel_appointment_detailsq');
Route::post('revenue_budget_details', 'HomeController@revenue_budget_details');
Route::post('revenue_actual_details', 'HomeController@revenue_actual_details');
Route::post('total_revenue_actual_details', 'HomeController@total_revenue_actual_details');
Route::post('other_revenue_monthly_details', 'HomeController@other_revenue_monthly_details');
Route::post('other_revenue_actual_details', 'HomeController@other_revenue_actual_details');
Route::post('total_other_revenue_actual_details', 'HomeController@total_other_revenue_actual_details');
Route::post('total_yearly_revenue_details', 'HomeController@total_yearly_revenue_details');
Route::post('monthly_expense_details', 'HomeController@monthly_expense_details');
Route::post('expense_actual_details', 'HomeController@expense_actual_details');
Route::post('total_expense_actual_details', 'HomeController@total_expense_actual_details');
Route::post('total_yearly_expenses_details', 'HomeController@total_yearly_expenses_details');
Route::post('erevenue_budget_details', 'HomeController@erevenue_budget_details');
Route::post('erevenue_actual_details', 'HomeController@erevenue_actual_details');
Route::post('eother_revenue_monthly_details', 'HomeController@eother_revenue_monthly_details');
Route::post('eother_revenue_actual_details', 'HomeController@eother_revenue_actual_details');
Route::post('emonthly_expense_details', 'HomeController@emonthly_expense_details');
Route::post('eexpense_actual_details', 'HomeController@eexpense_actual_details');
Route::post('monthly_asset_details', 'HomeController@monthly_asset_details');
Route::post('email_campaign_details', 'HomeController@email_campaign_details');
Route::post('send_email_details', 'HomeController@send_email_details');
Route::post('send_card_details', 'HomeController@send_card_details');
Route::post('send_video_details', 'HomeController@send_video_details');
Route::post('send_sms_details', 'HomeController@send_sms_details');
Route::get('add_holiday', 'HomeController@add_holiday');
Route::post('front_holiday_entry', 'HomeController@front_holiday_entry');
Route::get('all_monthly_budget_chart', 'HomeController@all_monthly_budget_chart');
Route::get('other_monthly_budget_chart', 'HomeController@other_monthly_budget_chart');
Route::get('all_quarterly_budget_chart', 'HomeController@all_quarterly_budget_chart');
Route::get('other_quarterly_budget_chart', 'HomeController@other_quarterly_budget_chart');
Route::post('monthlyyearlycomappointment', 'HomeController@monthlyyearlycomappointment');
Route::post('monthlyyearlycomemail_campaign', 'HomeController@monthlyyearlycomemail_campaign');
Route::post('monthlyyearlycomsend_email', 'HomeController@monthlyyearlycomsend_email');
Route::post('monthlyyearlycomsend_card', 'HomeController@monthlyyearlycomsend_card');
Route::post('monthlyyearlycomsend_video', 'HomeController@monthlyyearlycomsend_video');
Route::post('monthlyyearlycomsend_sms', 'HomeController@monthlyyearlycomsend_sms');
Route::post('monthlyyearlyrevenue', 'HomeController@monthlyyearlyrevenue');
Route::post('monthlyyearlycomexpenses', 'HomeController@monthlyyearlycomexpenses');
Route::post('monthlyyearlycomasset', 'HomeController@monthlyyearlycomasset');
Route::get('comparison-tab11', 'HomeController@comparisontab11');
Route::post('quarterlyyearlycomappointment', 'HomeController@quarterlyyearlycomappointment');
Route::get('comparison-tab111', 'HomeController@comparisontab111');
Route::post('yearlycomappointment', 'HomeController@yearlycomappointment');
Route::get('comparison-tab33', 'HomeController@comparisontab33');
Route::post('quarterlyyearlycomemail_campaign', 'HomeController@quarterlyyearlycomemail_campaign');
Route::post('quarterlyyearlycomsend_email', 'HomeController@quarterlyyearlycomsend_email');
Route::post('quarterlyyearlycomsend_card', 'HomeController@quarterlyyearlycomsend_card');
Route::post('quarterlyyearlycomsend_video', 'HomeController@quarterlyyearlycomsend_video');
Route::post('quarterlyyearlycomsend_sms', 'HomeController@quarterlyyearlycomsend_sms');
Route::get('comparison-tab333', 'HomeController@comparisontab333');
Route::post('yearlycomemail_campaign', 'HomeController@yearlycomemail_campaign');
Route::post('yearlycomsend_email', 'HomeController@yearlycomsend_email');
Route::post('yearlycomsend_card', 'HomeController@yearlycomsend_card');
Route::post('yearlycomsend_video', 'HomeController@yearlycomsend_video');
Route::post('yearlycomsend_sms', 'HomeController@yearlycomsend_sms');
Route::get('comparison-tab44', 'HomeController@comparisontab44');
Route::post('quarterlyyearlyrevenue', 'HomeController@quarterlyyearlyrevenue');
Route::post('quarterlyyearlycomexpenses', 'HomeController@quarterlyyearlycomexpenses');
Route::post('quarterlyyearlycomasset', 'HomeController@quarterlyyearlycomasset');
Route::get('comparison-tab444', 'HomeController@comparisontab444');
Route::post('yearlyrevenue', 'HomeController@yearlyrevenue');
Route::post('yearlycomexpenses', 'HomeController@yearlycomexpenses');
Route::post('yearlycomasset', 'HomeController@yearlycomasset');
Route::get('comparison_finance2', 'HomeController@comparison_finance2');
Route::get('comparison_finance3', 'HomeController@comparison_finance3');
Route::get('comparison_appointment2', 'HomeController@comparison_appointment2');
Route::get('comparison_appointment3', 'HomeController@comparison_appointment3');
Route::get('balancesheet_report', 'HomeController@balancesheet_report');
Route::get('paymentbalance_report', 'HomeController@paymentbalance_report');
Route::get('paymentbalance_quaterly_report', 'HomeController@paymentbalance_quaterly_report');
Route::get('appointment_step3', 'HomeController@appointment_stepp3')->name('appointment_step3');
Route::get('upload_files', 'HomeController@upload_files')->name('upload_files');
Route::post('upload_file_submit', 'HomeController@upload_file_submit');
Route::post('upload_files_delete', 'HomeController@upload_files_delete');
Route::post('clientprevdetails', 'HomeController@clientprevdetails');
Route::post('clientemailavailability', 'HomeController@clientemailavailability');
Route::post('apppointmentnotificationpopup', 'HomeController@apppointmentnotificationpopup');
Route::post('apppointmentnotification', 'HomeController@apppointmentnotification');
Route::post('apppointmentnotificationtime', 'HomeController@apppointmentnotificationtime');
Route::get('change_password_front', 'HomeController@change_password_front');
Route::post('flat_shipping_charges', 'HomeController@flat_shipping_charges');
Route::get('tab32', 'HomeController@tab32');
Route::get('tab42', 'HomeController@tab42');
Route::get('tab52', 'HomeController@tab52');
Route::get('tab332', 'HomeController@tab332');
Route::get('tab442', 'HomeController@tab442');
Route::get('tab552', 'HomeController@tab552');
Route::post('fcomparisonmonthlygraph', 'HomeController@fcomparisonmonthlygraph');
Route::get('fcommonthgraph/{id}', 'HomeController@fcommonthgraph');
Route::get('fcommonthgraphex/{id}', 'HomeController@fcommonthgraphex');
Route::get('fcommonthgraphas/{id}', 'HomeController@fcommonthgraphas');
Route::get('fcommonthgraph2/{id}', 'HomeController@fcommonthgraph2');
Route::get('fcommonthgraphex2/{id}', 'HomeController@fcommonthgraphex2');
Route::get('fcommonthgraphas2/{id}', 'HomeController@fcommonthgraphas2');
Route::get('fcomyeargraph/{id}', 'HomeController@fcomyeargraph');
Route::get('fcomyeargraphex/{id}', 'HomeController@fcomyeargraphex');
Route::get('fcomyeargraphas/{id}', 'HomeController@fcomyeargraphas');
Route::get('acommonthgraph/{id}', 'HomeController@acommonthgraph');
Route::get('acommonthgraph2/{id}', 'HomeController@acommonthgraph2');
Route::get('acommonthgraph3/{id}', 'HomeController@acommonthgraph3');
Route::get('manage_appointment_client', 'MainController@manage_appointment_client');
Route::get('ecommonthgraph/{id}', 'HomeController@ecommonthgraph');
Route::get('ecommonthgraphse/{id}', 'HomeController@ecommonthgraphse');
Route::get('ecommonthgraphsc/{id}', 'HomeController@ecommonthgraphsc');
Route::get('ecommonthgraphsv/{id}', 'HomeController@ecommonthgraphsv');
Route::get('ecommonthgraphss/{id}', 'HomeController@ecommonthgraphss');
Route::get('ecommonthgraph2/{id}', 'HomeController@ecommonthgraph2');
Route::get('ecommonthgraphse2/{id}', 'HomeController@ecommonthgraphse2');
Route::get('ecommonthgraphsc2/{id}', 'HomeController@ecommonthgraphsc2');
Route::get('ecommonthgraphsv2/{id}', 'HomeController@ecommonthgraphsv2');
Route::get('ecommonthgraphss2/{id}', 'HomeController@ecommonthgraphss2');
Route::get('ecommonthgraph3/{id}', 'HomeController@ecommonthgraph3');
Route::get('ecommonthgraphse3/{id}', 'HomeController@ecommonthgraphse3');
Route::get('ecommonthgraphsc3/{id}', 'HomeController@ecommonthgraphsc3');
Route::get('ecommonthgraphsv3/{id}', 'HomeController@ecommonthgraphsv3');
Route::get('ecommonthgraphss3/{id}', 'HomeController@ecommonthgraphss3');
Route::get('user_change_appointment', 'MainController@user_change_appointment');
Route::get('user_change_appointment_view/{id}', 'MainController@user_change_appointment_view');
Route::get('user_change_appointment_step/{id}', 'MainController@user_change_appointment_step');
Route::get('user_appointment_step3', 'MainController@user_appointment_stepp3')->name('user_appointment_step3');
Route::get('user_cancel_appointment', 'MainController@user_cancel_appointment');
Route::post('user_delete_appointment', 'MainController@user_delete_appointment');
Route::get('affiliate_dashboard', 'MainController@affiliate_dashboard');
Route::get('front_dashboard', 'MainController@front_dashboard');
Route::get('calculator', 'MainController@calculator_function');
Route::get('member_appointment_step3/{id}', 'MainController@member_appointment_step3');
Route::post('member_appointment_step4_details', 'MainController@member_appointment_step4_details');
Route::get('member_appointment_step4', 'MainController@member_appointment_step4');
Route::get('member_appointment_step5', 'MainController@member_appointment_step5');
Route::post('member_appointment_additional', 'MainController@member_appointment_additional');
Route::get('member_confirm_appointment', 'MainController@member_confirm_appointment');
Route::get('member_final_appointment', 'MainController@member_final_appointment');
Route::get('member_print_appointment', 'MainController@member_print_appointment');
Route::get('add_to_client/{id}', 'MainController@add_to_client');
Route::get('add_to_client2/{id}', 'MainController@add_to_client2');
Route::get('add_to_client3/{id}', 'MainController@add_to_client3');
Route::get('member_appointment_step1', 'MainController@member_appointment_step1');
Route::post('member_appointment_step2', 'MainController@member_appointment_step2');
Route::get('member_appointment_step2_detail', 'MainController@member_appointment_step2_detail');
Route::post('member_appointment_stepp2', 'MainController@member_appointment_stepp2');
Route::get('member_appointment_stepp2_detail', 'MainController@member_appointment_stepp2_detail');
Route::post('member_appointment_steppp2', 'MainController@member_appointment_steppp2');
Route::get('member_appointment_steppp2_detail', 'MainController@member_appointment_steppp2_detail');
Route::get('member_change_appointment', 'MainController@member_change_appointment');
Route::get('member_change_appointment_view/{id}', 'MainController@member_change_appointment_view');
Route::post('member_appointmentstepdet', 'MainController@member_appointmentstepdet');
Route::post('member_appointment_date_availabilityy', 'MainController@member_appointment_date_availabilityy');
Route::post('account_description_amount', 'MainController@account_description_amount');
Route::post('account_description_amount2', 'MainController@account_description_amount2');
Route::post('quarterrevenue_budget_details', 'MainController@quarterrevenue_budget_details');
Route::post('quarterrevenue_actual_details', 'MainController@quarterrevenue_actual_details');
Route::post('other_revenue_quarterly_details', 'MainController@other_revenue_quarterly_details');
Route::post('quarterother_revenue_actual_details', 'MainController@quarterother_revenue_actual_details');
Route::post('quarterly_expense_details', 'MainController@quarterly_expense_details');
Route::post('quarterexpense_actual_details', 'MainController@quarterexpense_actual_details');
Route::post('user_appointmentstepdet', 'MainController@user_appointmentstepdet');
Route::post('user_appointment_date_availabilityy', 'MainController@user_appointment_date_availabilityy');
Route::get('temp_user_profile', 'MainController@temp_user_profile');
Route::post('grossweekdetails', 'MainController@grossweekdetails');
Route::post('otherrweekdetails', 'MainController@otherrweekdetails');
Route::post('expenseweekdetails', 'MainController@expenseweekdetails');
Route::post('revenuemonthdetails', 'MainController@revenuemonthdetails');
Route::post('paymentbalancerevenuemonthdetails', 'MainController@paymentbalancerevenuemonthdetails');
Route::post('get_revenue_by_month', 'MainController@get_revenue_by_month');
Route::post('get_revenue_by_quarter', 'MainController@get_revenue_by_quarter');
Route::post('paymentbalancequaterlyrevenuequarterdetails', 'MainController@paymentbalancequaterlyrevenuequarterdetails');
Route::post('revenuequarterdetails', 'MainController@revenuequarterdetails');
Route::post('expensemonthdetails', 'MainController@expensemonthdetails');
Route::post('expensequarterdetails', 'MainController@expensequarterdetails');
Route::get('front_archives', 'MainController@front_archives');
Route::get('expense_projection_anually', 'FrontReportController@expense_projection_anually');
Route::post('monthlylistfinance', 'MainController@monthlylistfinance');
Route::post('quarterlylistfinance', 'MainController@quarterlylistfinance');
Route::post('appointmentdashboardcount', 'MainController@appointmentdashboardcount');
Route::post('appointmentdashboardcountbasis', 'MainController@appointmentdashboardcountbasis');
Route::post('appointmentdashboardcountbasiss', 'MainController@appointmentdashboardcountbasiss');
Route::get('new_client_lists', 'MainController@new_client_lists');
Route::get('dashboard_revenue_report', 'MainController@dashboard_revenue_report');
Route::get('dashboard_expenses_report', 'MainController@dashboard_expenses_report');
Route::get('dashboard_profit_loss_stmt', 'MainController@dashboard_profit_loss_stmt');
Route::get('dashboard_manage_appointment', 'MainController@dashboard_manage_appointment');
Route::post('sales_tax_account', 'MainController@sales_tax_account');
Route::post('shipping_collected', 'MainController@shipping_collected');
Route::get('notifications', 'MainController@notifications');
Route::get('deactive_user_access_rights/{email}', 'MainController@deactive_user_access_rights');
Route::get('active_user_access_rights/{email}', 'MainController@active_user_access_rights');
Route::get('comparisontemplate1', 'MainController@comparisontemplate1');
Route::get('comparisontemplate2', 'MainController@comparisontemplate2');
Route::post('monthlyyearlycomprofitloss', 'MainController@monthlyyearlycomprofitloss');
Route::post('quarterlyyearlycomprofitloss', 'MainController@quarterlyyearlycomprofitloss');
Route::post('yearlycomprofitloss', 'MainController@yearlycomprofitloss');
Route::get('member_change_appointment_step/{id}', 'MainController@member_change_appointment_step');
Route::get('member_appointment_step3', 'MainController@member_appointment_step3');
Route::get('member_cancel_appointment', 'MainController@member_cancel_appointment');
Route::post('member_delete_appointment', 'MainController@member_delete_appointment');
Route::get('member_profile_info', 'MainController@member_profile_info');
Route::get('member_library_form', 'MainController@member_library_form');
Route::get('member-library-form/{id}', 'MainController@member_library_form_view');
Route::get('download_pdf/{id}', 'MainController@download_pdf');
Route::post('update_client_forms_library', 'MainController@update_client_forms_library');
Route::post('client_report_submit', 'MainController@client_report_submit');
Route::post('client_diagnostic_report_submit', 'MainController@client_diagnostic_report_submit');
Route::post('client_recommendation_submit', 'MainController@client_recommendation_submit');
Route::post('client_medication_submit', 'MainController@client_medication_submit');
Route::post('affiliate_client_report_submit', 'MainController@affiliate_client_report_submit');
Route::post('affiliate_client_diagnostic_report_submit', 'MainController@affiliate_client_diagnostic_report_submit');
Route::post('affiliate_client_recommendation_submit', 'MainController@affiliate_client_recommendation_submit');
Route::post('affiliate_client_medication_submit', 'MainController@affiliate_client_medication_submit');\
Route::post('reportstatuschange', 'MainController@reportstatuschange');
Route::post('reportstatuschange2', 'MainController@reportstatuschange2');
Route::post('affiliate_client_task_submit', 'MainController@affiliate_client_task_submit');
Route::post('affiliate_client_task_delete', 'MainController@affiliate_client_task_delete');
Route::get('member_tasks', 'MainController@member_tasks');
Route::post('client_task_submit', 'MainController@client_task_submit');
Route::post('affiliate_client_task_confirm', 'MainController@affiliate_client_task_confirm');
Route::get('admin_set_background', 'AdminController@admin_set_background');
Route::post('background_color_submit', 'AdminController@background_color_submit');
Route::post('image_update_banner', 'AdminController@image_update_banner');
Route::get('popup1_settings', 'AdminController@popup1_settings');
Route::post('popup_settings_submit', 'AdminController@popup_settings_submit');
Route::post('image_update_banner2', 'AdminController@image_update_banner2');
Route::post('upload_financial_template_entry2', 'AdminController@upload_financial_template_entry2');
Route::get('editupload_financial_template2/{id}', 'AdminController@editupload_financial_template2');
Route::get('deleteupload_financial_template2/{id}', 'AdminController@deleteupload_financial_template2');
Route::post('upload_financial_template_update2', 'AdminController@upload_financial_template_update2');
Route::get('survey_polls', 'MainController@survey_polls')->name('survey_polls');
Route::post('submit_form_servey_data', 'MainController@submit_form_servey_data');
Route::post('search_a_business', 'MainController@search_a_business');
Route::post('revenue_template_submit', 'MainController@revenue_template_submit');
Route::post('expenses_template_submit', 'MainController@expenses_template_submit');
Route::post('balancesheet_template_submit', 'MainController@balancesheet_template_submit');
Route::get('get_genealogy_report', 'AdminController@get_genealogy_report');

Route::get('get_genealogy_uplines_data', 'AdminController@get_genealogy_uplines_data');
Route::get('get_genealogy_downlines_data', 'AdminController@get_genealogy_downlines_data');

Route::get('admin_survey_polls', 'AdminController@admin_survey_polls');
Route::get('admin_user_records', 'AdminController@admin_user_records');
Route::post('admin_survey_entry', 'AdminController@admin_survey_entry');
Route::get('edit_admin_survey/{id}', 'AdminController@edit_admin_survey');
Route::post('admin_survey_update', 'AdminController@admin_survey_update');
Route::get('delete_admin_survey/{id}', 'AdminController@delete_admin_survey');
Route::post('revenue_account_check', 'MainController@revenue_account_check');
Route::post('balancesheet_account_check', 'MainController@balancesheet_account_check');
Route::post('revenue_new_account_submit', 'MainController@revenue_new_account_submit');
Route::post('balancesheet_new_account_submit', 'MainController@balancesheet_new_account_submit');
Route::post('expense_account_check', 'MainController@expense_account_check');
Route::post('expense_new_account_submit', 'MainController@expense_new_account_submit');
Route::get('business_registration', 'MainController@business_registration');
Route::post('free_affiliate_entry', 'MainController@free_affiliate_entry');
Route::post('business_search_step2', 'MainController@business_search_step2');
Route::post('business_search_stepp2', 'MainController@business_search_stepp2');
Route::post('business_search_steppp2', 'MainController@business_search_steppp2');
Route::get('business_search_step2_detail', 'MainController@business_search_step2_detail');
Route::get('business_search_stepp2_detail', 'MainController@business_search_stepp2_detail');
Route::get('business_search_steppp2_detail', 'MainController@business_search_steppp2_detail');
Auth::routes();
Route::get('/admin', 'HomeController@index')->name('admin');
Route::get('admin/rating', 'AdminController@rating')->name('ratings');
Route::get('admin/hide_unhide', 'AdminController@hide_unhide')->name('hide_unhide');
Route::post('hideunhidestatus', 'AdminController@hideunhidestatus');
Route::post('hideunhidestatuss', 'AdminController@hideunhidestatuss');
Route::post('allunhide', 'AdminController@allunhide');
Route::post('allhide', 'AdminController@allhide');
Route::get('level_table', 'AdminController@level_table');
Route::post('levelentry', 'AdminController@levelentry');
Route::get('editlevelentry/{id}', 'AdminController@editlevelentry');
Route::post('updatelevelentry', 'AdminController@updatelevelentry');
Route::get('deletelevelentry/{id}', 'AdminController@deletelevelentry');
Route::post('affiliatedisplay', 'AdminController@affiliatedisplay');
Route::get('admin/photo_slides', 'AdminController@photo_slides');
Route::post('photo_slide_entry', 'AdminController@photo_slide_entry');
Route::get('editphoto_slide/{id}', 'AdminController@editphoto_slide');
Route::post('photo_slide_update', 'AdminController@photo_slide_update');
Route::get('deletephoto_slide/{id}', 'AdminController@deletephoto_slide');
Route::get('admin/top_banner', 'AdminController@top_banner');
Route::post('top_banner_entry', 'AdminController@top_banner_entry');
Route::get('edittop_banner/{id}', 'AdminController@edittop_banner');
Route::post('top_banner_update', 'AdminController@top_banner_update');
Route::get('deletetop_banner/{id}', 'AdminController@deletetop_banner');
Route::get('admin/text_banner', 'AdminController@text_banner');
Route::post('text_banner_entry', 'AdminController@text_banner_entry');
Route::get('edittext_banner/{id}', 'AdminController@edittext_banner');
Route::post('text_banner_update', 'AdminController@text_banner_update');
Route::get('deletetext_banner/{id}', 'AdminController@deletetext_banner');
Route::post('text_banner_paytime', 'AdminController@text_banner_paytime');
Route::post('top_banner_paytime', 'AdminController@top_banner_paytime');
Route::post('banner_paytime', 'AdminController@banner_paytime');
Route::get('admin/home_videos', 'AdminController@home_videos');
Route::post('home_video_entry', 'AdminController@home_video_entry');
Route::get('edithome_videos/{id}', 'AdminController@edithome_videos');
Route::post('home_video_update', 'AdminController@home_video_update');
Route::get('deletehome_videos/{id}', 'AdminController@deletehome_videos');
Route::get('admin/home_top_videos', 'AdminController@home_top_videos');
Route::post('home_top_video_entry', 'AdminController@home_top_video_entry');
Route::get('edithome_top_videos/{id}', 'AdminController@edithome_top_videos');
Route::post('home_top_video_update', 'AdminController@home_top_video_update');
Route::get('deletehome_top_videos/{id}', 'AdminController@deletehome_top_videos');
Route::get('admin/home_main_videos', 'AdminController@home_main_videos');
Route::post('home_main_video_entry', 'AdminController@home_main_video_entry');
Route::get('edithome_main_videos/{id}', 'AdminController@edithome_main_videos');
Route::post('home_main_video_update', 'AdminController@home_main_video_update');
Route::get('deletehome_main_videos/{id}', 'AdminController@deletehome_main_videos');
Route::get('admin/setting_banner', 'AdminController@setting_banner');
Route::post('setting_banner_entry', 'AdminController@setting_banner_entry');
Route::get('editsetting_banner/{id}', 'AdminController@editsetting_banner');
Route::post('setting_banner_update', 'AdminController@setting_banner_update');
Route::get('deletesetting_banner/{id}', 'AdminController@deletesetting_banner');
Route::get('admin/appointment_banner', 'AdminController@appointment_banner');
Route::post('appointment_banner_entry', 'AdminController@appointment_banner_entry');
Route::get('editappointment_banner/{id}', 'AdminController@editappointment_banner');
Route::post('appointment_banner_update', 'AdminController@appointment_banner_update');
Route::get('deleteappointment_banner/{id}', 'AdminController@deleteappointment_banner');
Route::get('admin/client_management_banner', 'AdminController@client_management_banner');
Route::post('client_management_banner_entry', 'AdminController@client_management_banner_entry');
Route::get('editclient_management_banner/{id}', 'AdminController@editclient_management_banner');
Route::post('client_management_banner_update', 'AdminController@client_management_banner_update');
Route::get('deleteclient_management_banner/{id}', 'AdminController@deleteclient_management_banner');
Route::get('admin/email_management_banner', 'AdminController@email_management_banner');
Route::post('email_management_banner_entry', 'AdminController@email_management_banner_entry');
Route::get('editemail_management_banner/{id}', 'AdminController@editemail_management_banner');
Route::post('email_management_banner_update', 'AdminController@email_management_banner_update');
Route::get('deleteemail_management_banner/{id}', 'AdminController@deleteemail_management_banner');
Route::get('admin/financial_management_banner', 'AdminController@financial_management_banner');
Route::post('financial_management_banner_entry', 'AdminController@financial_management_banner_entry');
Route::get('editfinancial_management_banner/{id}', 'AdminController@editfinancial_management_banner');
Route::post('financial_management_banner_update', 'AdminController@financial_management_banner_update');
Route::get('deletefinancial_management_banner/{id}', 'AdminController@deletefinancial_management_banner');
Route::get('admin/archives_banner', 'AdminController@archives_banner');
Route::post('archives_banner_entry', 'AdminController@archives_banner_entry');
Route::get('editarchives_banner/{id}', 'AdminController@editarchives_banner');
Route::post('archives_banner_update', 'AdminController@archives_banner_update');
Route::get('deletearchives_banner/{id}', 'AdminController@deletearchives_banner');
Route::get('admin/setting_tutorials', 'AdminController@setting_tutorials');
Route::post('setting_tutorials_entry', 'AdminController@setting_tutorials_entry');
Route::get('editsetting_tutorial/{id}', 'AdminController@editsetting_tutorial');
Route::post('setting_tutorials_update', 'AdminController@setting_tutorials_update');
Route::get('deletesetting_tutorial/{id}', 'AdminController@deletesetting_tutorial');
Route::get('admin/appoitment_tutorials', 'AdminController@appoitment_tutorials');
Route::get('admin/introduction-videos/{slug}', 'AdminController@introduction_videos')->name('admin_introduction_videos');
//Route::get('admin/introduction-videos/{id}', 'AdminController@introduction_videos');
Route::post('appointment_tutorials_entry', 'AdminController@appointment_tutorials_entry');
Route::post('introduction_videos_entry', 'AdminController@introduction_videos_entry');
Route::post('intro_video_update/{slug}', 'AdminController@intro_video_update')->name('intro_video_update');
Route::get('editappointment_tutorial/{id}', 'AdminController@editappointment_tutorial');
Route::post('appointment_tutorials_update', 'AdminController@appointment_tutorials_update');
Route::get('deleteappointment_tutorial/{id}', 'AdminController@deleteappointment_tutorial');
Route::get('deleteintro_video/{id}', 'AdminController@deleteintro_video');
Route::get('admin/client_tutorials', 'AdminController@client_tutorials');
Route::post('client_tutorials_entry', 'AdminController@client_tutorials_entry');
Route::get('editclient_tutorial/{id}', 'AdminController@editclient_tutorial');
Route::post('client_tutorials_update', 'AdminController@client_tutorials_update');
Route::get('deleteclient_tutorial/{id}', 'AdminController@deleteclient_tutorial');
Route::get('admin/email_tutorials', 'AdminController@email_tutorials');
Route::post('email_tutorials_entry', 'AdminController@email_tutorials_entry');
Route::get('editemail_tutorial/{id}', 'AdminController@editemail_tutorial');
Route::post('email_tutorials_update', 'AdminController@email_tutorials_update');
Route::get('deleteemail_tutorial/{id}', 'AdminController@deleteemail_tutorial');
Route::get('admin/finance_tutorials', 'AdminController@finance_tutorials');
Route::post('finance_tutorials_entry', 'AdminController@finance_tutorials_entry');
Route::get('editfinance_tutorial/{id}', 'AdminController@editfinance_tutorial');
Route::post('finance_tutorials_update', 'AdminController@finance_tutorials_update');
Route::get('deletefinance_tutorial/{id}', 'AdminController@deletefinance_tutorial');
Route::get('admin/archive_tutorials', 'AdminController@archive_tutorials');
Route::post('archive_tutorials_entry', 'AdminController@archive_tutorials_entry');
Route::get('editarchive_tutorial/{id}', 'AdminController@editarchive_tutorial');
Route::post('archive_tutorials_update', 'AdminController@archive_tutorials_update');
Route::get('deletearchive_tutorial/{id}', 'AdminController@deletearchive_tutorial');
Route::get('admin/terms_conditions', 'AdminController@terms_conditions');
Route::post('terms_conditions_entry', 'AdminController@terms_conditions_entry');
Route::get('editterms_condition/{id}', 'AdminController@editterms_condition');
Route::post('terms_conditions_update', 'AdminController@terms_conditions_update');
Route::get('deleteterms_condition/{id}', 'AdminController@deleteterms_condition');
Route::get('admin/archives', 'AdminController@archives');
Route::post('archives_entry', 'AdminController@archives_entry');
Route::get('editarchives/{id}', 'AdminController@editarchives');
Route::post('archives_update', 'AdminController@archives_update');
Route::get('deletearchives/{id}', 'AdminController@deletearchives');
Route::get('admin_category_popup1', 'AdminController@admin_category_popup1');
Route::post('popup1_entry', 'AdminController@popup1_entry');
Route::get('editpopup1/{id}', 'AdminController@editpopup1');
Route::post('popup1_update', 'AdminController@popup1_update');
Route::get('deletepopup1/{id}', 'AdminController@deletepopup1');
Route::get('admin_category_popup2', 'AdminController@admin_category_popup2');
Route::post('popup2_entry', 'AdminController@popup2_entry');
Route::get('editpopup2/{id}', 'AdminController@editpopup2');
Route::post('popup2_update', 'AdminController@popup2_update');
Route::get('deletepopup2/{id}', 'AdminController@deletepopup2');
Route::get('admin_upload_popup1', 'AdminController@admin_upload_popup1');
Route::get('admin_upload_popup2', 'AdminController@admin_upload_popup2');
Route::post('uploadpopup1_entry', 'AdminController@uploadpopup1_entry');
Route::post('uploadpopup2_entry', 'AdminController@uploadpopup2_entry');
Route::get('edituploadpopup1/{id}', 'AdminController@edituploadpopup1');
Route::post('uploadpopup1_update', 'AdminController@uploadpopup1_update');
Route::get('deleteuploadpopup1/{id}', 'AdminController@deleteuploadpopup1');
Route::get('edituploadpopup2/{id}', 'AdminController@edituploadpopup2');
Route::post('uploadpopup2_update', 'AdminController@uploadpopup2_update');
Route::get('deleteuploadpopup2/{id}', 'AdminController@deleteuploadpopup2');
Route::get('create_template_category', 'AdminController@create_template_category');
Route::post('client_template_category_entry', 'AdminController@client_template_category_entry');
Route::get('editclient_template_category/{id}', 'AdminController@editclient_template_category');
Route::post('client_template_category_update', 'AdminController@client_template_category_update');
Route::get('deleteclient_template_category/{id}', 'AdminController@deleteclient_template_category');
Route::get('create_financial_template_category', 'AdminController@create_financial_template_category');
Route::post('financial_template_category_entry', 'AdminController@financial_template_category_entry');
Route::get('editfinancial_template_category/{id}', 'AdminController@editfinancial_template_category');
Route::post('financial_template_category_update', 'AdminController@financial_template_category_update');
Route::get('deletefinancial_template_category/{id}', 'AdminController@deletefinancial_template_category');
Route::get('admin_upload_template_category', 'AdminController@admin_upload_template_category');
Route::post('uploadtemplate_entry', 'AdminController@uploadtemplate_entry');
Route::get('edituploadtemplate/{id}', 'AdminController@edituploadtemplate');
Route::post('uploadtemplate_update', 'AdminController@uploadtemplate_update');
Route::get('deleteuploadtemplate/{id}', 'AdminController@deleteuploadtemplate');
Route::get('admin_upload_financial_template_category', 'AdminController@admin_upload_financial_template_category');
Route::get('admin_upload_balancesheet_template_category', 'AdminController@admin_upload_balancesheet_template_category');
Route::get('admin_upload_balancesheet_template_category/{id}', 'AdminController@edit_upload_balancesheet_template_category');
Route::post('upload_balancesheet_template_entry', 'AdminController@upload_balancesheet_template_entry');
Route::post('upload_financial_template_entry', 'AdminController@upload_financial_template_entry');
Route::get('editupload_financial_template/{id}', 'AdminController@editupload_financial_template');
Route::post('upload_balancesheet_template_update', 'AdminController@upload_balancesheet_template_update');
Route::post('upload_financial_template_update', 'AdminController@upload_financial_template_update');
Route::get('deleteupload_balancesheet_template/{id}', 'AdminController@deleteupload_balancesheet_template');
Route::get('deleteupload_financial_template/{id}', 'AdminController@deleteupload_financial_template');
Route::get('admin/affiliate_users', 'AdminController@affiliate_users');
Route::get('admin/nonaffiliates_registration', 'AdminController@nonaffiliates_registration');
Route::get('view_nonaffiliates_registration/{id}', 'AdminController@view_nonaffiliates_registration');
Route::get('edit_nonaffiliates_registration/{id}', 'AdminController@edit_nonaffiliates_registration');
Route::post('nonaffiliates_update', 'AdminController@nonaffiliates_update');
Route::post('delete_nonaffiliates_registration', 'AdminController@delete_nonaffiliates_registration');
Route::get('admin/affilates_registration', 'AdminController@affilates_registration');
Route::get('admin/registered_business', 'AdminController@registered_business');
Route::get('add_affilates_registration', 'AdminController@add_affilates_registration');
Route::post('affiliate_entry', 'AdminController@affiliate_entry');
Route::get('view_affilates_registration/{id}', 'AdminController@view_affilates_registration');
Route::get('edit_affilates_registration/{id}', 'AdminController@edit_affilates_registration');
Route::post('affiliate_update', 'AdminController@affiliate_update');
Route::post('delete_affilates_registration', 'AdminController@delete_affilates_registration');
Route::post('update_account_status', 'AdminController@update_account_status');
Route::post('addclient_appointment', 'HomeController@addclient_appointment');
Route::get('admin_religion', 'AdminController@admin_religion');
Route::post('religion_entry', 'AdminController@religion_entry');
Route::get('editreligion/{id}', 'AdminController@editreligion');
Route::post('religion_update', 'AdminController@religion_update');
Route::get('deletereligion/{id}', 'AdminController@deletereligion');
Route::get('admin_card_category', 'AdminController@admin_card_category');
Route::post('card_category_entry', 'AdminController@card_category_entry');
Route::get('editcard_category/{id}', 'AdminController@editcard_category');
Route::post('card_category_update', 'AdminController@card_category_update');
Route::get('deletecard_category/{id}', 'AdminController@deletecard_category');
Route::get('admin_script_category', 'AdminController@admin_script_category');
Route::post('script_category_entry', 'AdminController@script_category_entry');
Route::get('editscript_category/{id}', 'AdminController@editscript_category');
Route::post('script_category_update', 'AdminController@script_category_update');
Route::get('deletescript_category/{id}', 'AdminController@deletescript_category');
Route::get('admin_business_category', 'AdminController@admin_business_category');
Route::post('business_category_entry', 'AdminController@business_category_entry');
Route::post('mark-as-medical-category', 'AdminController@mark_as_medical_category');
Route::get('editbusiness_category/{id}', 'AdminController@editbusiness_category');
Route::post('business_category_update', 'AdminController@business_category_update');
Route::get('deletebusiness_category/{id}', 'AdminController@deletebusiness_category');
Route::get('admin_leads_category', 'AdminController@admin_leads_category');
Route::post('leads_category_entry', 'AdminController@leads_category_entry');
Route::get('editleads_category/{id}', 'AdminController@editleads_category');
Route::post('leads_category_update', 'AdminController@leads_category_update');
Route::get('deleteleads_category/{id}', 'AdminController@deleteleads_category');
Route::get('admin_upload_card', 'AdminController@admin_upload_card');
Route::post('uploadcard_entry', 'AdminController@uploadcard_entry');
Route::get('edituploadcard/{id}', 'AdminController@edituploadcard');
Route::post('uploadcard_update', 'AdminController@uploadcard_update');
Route::get('deleteuploadcard/{id}', 'AdminController@deleteuploadcard');
Route::get('admin_upload_script', 'AdminController@admin_upload_script');
Route::post('uploadscript_entry', 'AdminController@uploadscript_entry');
Route::get('edituploadscript/{id}', 'AdminController@edituploadscript');
Route::post('uploadscript_update', 'AdminController@uploadscript_update');
Route::get('deleteuploadscript/{id}', 'AdminController@deleteuploadscript');
Route::get('admin_upload_business', 'AdminController@admin_upload_business');
Route::post('uploadbusiness_entry', 'AdminController@uploadbusiness_entry');
Route::get('edituploadbusiness/{id}', 'AdminController@edituploadbusiness');
Route::post('uploadbusiness_update', 'AdminController@uploadbusiness_update');
Route::get('deleteuploadbusiness/{id}', 'AdminController@deleteuploadbusiness');
Route::get('admin_upload_leads', 'AdminController@admin_upload_leads');
Route::post('uploadleads_entry', 'AdminController@uploadleads_entry');
Route::get('edituploadleads/{id}', 'AdminController@edituploadleads');
Route::post('uploadleads_update', 'AdminController@uploadleads_update');
Route::get('deleteuploadleads/{id}', 'AdminController@deleteuploadleads');
Route::post('checkacode', 'AdminController@checkacode');
Route::post('edit_clientf', 'HomeController@edit_clientf');
Route::post('updateclient_appointment', 'HomeController@updateclient_appointment');
Route::get('delete_clientf/{id}', 'HomeController@delete_clientf');
Route::get('showhome_top_videos/{id}', 'AdminController@showhome_top_videos');
Route::get('hidehome_top_videos/{id}', 'AdminController@hidehome_top_videos');
Route::post('send_card_submit', 'HomeController@send_card_submit');
Route::post('send_cards_send_on', 'HomeController@send_cards_send_on');
Route::post('send_cards_send_with_reminder', 'HomeController@send_cards_send_with_reminder');
Route::post('send_email_submit', 'HomeController@send_email_submit');
Route::post('send_email_send_on', 'HomeController@send_email_send_on');
Route::post('send_email_send_with_reminder', 'HomeController@send_email_send_with_reminder');
Route::post('send_video_submit', 'HomeController@send_video_submit');
Route::post('send_video_send_on', 'HomeController@send_video_send_on');
Route::post('send_video_send_with_reminder', 'HomeController@send_video_send_with_reminder');
Route::post('send_sms_send_on', 'HomeController@send_sms_send_on');
Route::post('send_sms_send_with_reminder', 'HomeController@send_sms_send_with_reminder');
Route::post('send_sms_submit', 'HomeController@send_sms_submit');
Route::post('email_campaign_submit', 'HomeController@email_campaign_submit');
Route::post('manage_folders_entry', 'HomeController@manage_folders_entry');
Route::post('edit_manage_folders', 'HomeController@edit_manage_folders');
Route::post('delete_manage_folders', 'HomeController@delete_manage_folders');
Route::post('view_manage_folders', 'HomeController@view_manage_folders');
Route::post('manage_contacts_entry', 'HomeController@manage_contacts_entry');
Route::post('edit_manage_contacts', 'HomeController@edit_manage_contacts');
Route::post('manage_contacts_update', 'HomeController@manage_contacts_update');
Route::post('delete_manage_contacts', 'HomeController@delete_manage_contacts');
Route::post('manage_folders_update', 'HomeController@manage_folders_update');
Route::post('edit_manage_emails', 'HomeController@edit_manage_emails');
Route::post('manage_emails_update', 'HomeController@manage_emails_update');
Route::post('delete_manage_emails', 'HomeController@delete_manage_emails');
Route::post('get_manage_emails', 'HomeController@get_manage_emails');
Route::post('folderwisecontact', 'HomeController@folderwisecontact');
Route::post('folderwisecontactids', 'HomeController@folderwisecontactids');
Route::post('contactwisemail', 'HomeController@contactwisemail');
Route::post('contactwisphone', 'HomeController@contactwisphone');
Route::post('contactwisemaild', 'HomeController@contactwisemaild');
Route::post('contactwisephoneId', 'HomeController@contactwisephoneId');
Route::post('checkboxesmail', 'HomeController@checkboxesmail');
Route::get('access_roles', 'AdminController@access_roles');
Route::get('add_access_roles', 'AdminController@add_access_roles');
Route::get('restrict_signup', 'AdminController@restrict_signup');
//ram route here
Route::post('update_financial_invoice_setup', 'HomeController@update_financial_invoice_setup');
Route::get('assign_users', 'AdminController@assign_users');
Route::get('search_send_sms', 'AdminController@search_send_sms');
Route::get('search_send_emails', 'AdminController@search_send_emails');
Route::get('access_monitoring', 'MLMAdminController@access_monitoring');
Route::get('show_hide_links', 'AdminController@show_hide_links');
Route::get('basket_leads_rotation', 'AdminController@basket_leads_rotation');
Route::get('basket1_condition', 'AdminController@basket1_condition');
Route::get('basket2_condition', 'AdminController@basket2_condition');
Route::get('basket3_condition', 'AdminController@basket3_condition');
Route::get('basket4_condition', 'AdminController@basket4_condition');
Route::get('comm_table', 'AdminController@comm_table');
Route::get('show_hide_bonus_pools', 'AdminController@show_hide_bonus_pools');
Route::get('show_hide_prize_btn', 'AdminController@show_hide_prize_btn');
Route::get('change_password', 'AdminController@change_password');
Route::get('change-password', 'ChangePasswordController@index');
Route::post('change-password', 'ChangePasswordController@store')->name('change.password');
Route::get('manage_department', 'AdminController@manage_department');
Route::post('department_entry', 'AdminController@department_entry');
Route::get('delete_manage_department/{id}', 'AdminController@delete_manage_department');
Route::get('edit_manage_department/{id}', 'AdminController@edit_manage_department');
Route::post('department_update', 'AdminController@department_update');
Route::get('upload_department', 'AdminController@upload_department');
Route::post('department_upload_entry', 'AdminController@department_upload_entry');
Route::get('upload_department_edit/{id}', 'AdminController@upload_department_edit');
Route::post('department_upload_update', 'AdminController@department_upload_update');
Route::get('upload_department_delete/{id}', 'AdminController@upload_department_delete');
Route::get('arrondissements', 'AdminController@arrondissements');
Route::post('arrondissements_entry', 'AdminController@arrondissements_entry');
Route::get('arrondissements_edit/{id}', 'AdminController@arrondissements_edit');
Route::post('arrondissements_update', 'AdminController@arrondissements_update');
Route::get('arrondissements_delete/{id}', 'AdminController@arrondissements_delete');
Route::get('upload_arrondissements', 'AdminController@upload_arrondissements');
Route::post('arrondissements_upload_entry', 'AdminController@arrondissements_upload_entry');
Route::get('upload_arrondissements_edit/{id}', 'AdminController@upload_arrondissements_edit');
Route::post('arrondissements_upload_update', 'AdminController@arrondissements_upload_update');
Route::get('upload_arrondissements_delete/{id}', 'AdminController@upload_arrondissements_delete');
Route::get('manage_communes', 'AdminController@manage_communes');
Route::post('communes_entry', 'AdminController@communes_entry');
Route::get('manage_communes_edit/{id}', 'AdminController@manage_communes_edit');
Route::post('communes_update', 'AdminController@communes_update');
Route::get('manage_communes_delete/{id}', 'AdminController@manage_communes_delete');
Route::get('upload_communes', 'AdminController@upload_communes');
Route::post('communes_upload_entry', 'AdminController@communes_upload_entry');
Route::get('upload_communes_edit/{id}', 'AdminController@upload_communes_edit');
Route::post('communes_upload_update', 'AdminController@communes_upload_update');
Route::get('upload_communes_delete/{id}', 'AdminController@upload_communes_delete');
Route::get('chat_room', 'AdminController@chat_room');
Route::get('manage_blog', 'AdminController@manage_blog');
Route::post('blog_entry', 'AdminController@blog_entry');
Route::get('manage_blog_edit/{id}', 'AdminController@manage_blog_edit');
Route::post('blog_update', 'AdminController@blog_update');
Route::get('manage_blog_delete/{id}', 'AdminController@manage_blog_delete');
Route::get('setting_front', 'AdminController@setting_front');
Route::get('appointment_front', 'AdminController@appointment_front');
Route::get('client_mgmt_front', 'AdminController@client_mgmt_front');
Route::get('email_mgmt_front', 'AdminController@email_mgmt_front');
Route::get('financial_mgmt_front', 'AdminController@financial_mgmt_front');
Route::get('archives_front', 'AdminController@archives_front');
Route::get('affilate_features_access', 'AdminController@affilate_features_access');
Route::get('gold_features_access', 'AdminController@gold_features_access');
Route::get('sliver_features_access', 'AdminController@sliver_features_access');
Route::get('enterprises_feature_access', 'AdminController@enterprises_feature_access');
Route::get('pricing_table', 'AdminController@pricing_table');
Route::get('upgarde_package', 'AdminController@upgarde_package');
Route::get('affiliates_promotion_condition', 'AdminController@affiliates_promotion_condition');
Route::get('genealogy_report', 'AdminController@genealogy_report');
Route::get('user_report', 'AdminController@user_report'); //by AA
Route::post('user_report_search_result', 'AdminController@user_report_search_result'); //by AA

Route::get('admin_birthplace_view/{email}', 'AdminController@admin_birthplace_view'); //by AA

Route::get('performance_report', 'AdminController@performance_report');
Route::get('qualification_report', 'AdminController@qualification_report');
Route::get('reconciliation_report', 'AdminController@reconciliation_report');
Route::get('comission_report', 'AdminController@comission_report');
Route::get('comprehensive_report', 'AdminController@comprehensive_report');
Route::get('move_baskets', 'AdminController@move_baskets');
Route::get('enterprise_mgmt', 'AdminController@enterprise_mgmt');
Route::get('enterprise_profile', 'AdminController@enterprise_profile');
Route::get('showhome_photoslide/{id}', 'AdminController@showhome_photoslide');
Route::get('hidehome_photoslide/{id}', 'AdminController@hidehome_photoslide');
Route::get('admin_personalised_greeting', 'AdminController@admin_personalised_greeting');
Route::post('personalised_greeting_entry', 'AdminController@personalised_greeting_entry');
Route::get('delete_personalised_greeting/{id}', 'AdminController@delete_personalised_greeting');
Route::get('admin_schedule_holiday', 'AdminController@admin_schedule_holiday');
Route::post('holiday_entry', 'AdminController@holiday_entry');
Route::get('deleteholiday/{id}', 'AdminController@deleteholiday');
// ramkishor routes
Route::get('admin/google-analytics', 'MLMAdminController@google_analytic_setting');
Route::get('admin/payment-gateway-setting', 'MLMAdminController@payment_gateway_setting');
Route::get('admin/smtp-setting', 'MLMAdminController@smtp_setting');
Route::get('admin/admin-roles', 'RoleController@admin_roles');
Route::get('admin/admin-list', 'RoleController@admin_list');
Route::get('admin/add-new-role', 'RoleController@add_new_role');
Route::get('admin/add-new-role/{id}', 'RoleController@add_new_role');
Route::get('admin/add-new-admin', 'RoleController@add_new_admin');
Route::get('admin/add-new-admin/{id}', 'RoleController@add_new_admin');
Route::post('manageAdminRole', 'RoleController@manageAdminRole')->name('manageAdminRole');
Route::post('manageAdminAccount', 'RoleController@manageAdminAccount')->name('manageAdminAccount');

Route::post('update_plan_menu_perimission', 'MLMAdminController@update_plan_menu_perimission');
Route::post('update_smtp_setting', 'MLMAdminController@update_smtp_setting');
Route::post('update_payment_gateway_setting', 'MLMAdminController@update_payment_gateway_setting');
Route::post('update_google_analytics', 'MLMAdminController@update_google_analytics');
Route::get('bonus_condition_table', 'MLMAdminController@bonus_condition_table');
Route::get('prize_condition_table', 'MLMAdminController@prize_condition_table');
Route::get('other_condition_table', 'MLMAdminController@other_condition_table');
Route::get('admin/affilates_registration_enquiry', 'MLMAdminController@affilates_registration_enquiry');

Route::post('notificationsfilterbydates', 'MLMAdminController@notificationsfilterbydates');

Route::get('admin/notifications', 'MLMAdminController@logActivity');
Route::get('affiliate_registration', 'MLMHomeController@affiliate_registration');
Route::get('affiliate_registration/{user_id}/{code}', 'MLMHomeController@affiliate_registration')->name('affiliate_registration');

Route::get('affiliate-preview/{user_id}', 'MLMHomeController@affiliate_preview')->name('affiliate-preview');
Route::get('user/{username}', 'MLMHomeController@affiliate_profile_view');
Route::post('adaffiliate_entry', 'MLMHomeController@adaffiliate_entry');
Route::post('complete_registration', 'MLMHomeController@complete_registration_update');
Route::post('invite-users', 'MLMHomeController@send_invitation_link');
Route::get('registration-success', 'MLMHomeController@registration_success')->name('registration-success');
Route::get('add-to-log', 'MLMHomeController@myTestAddToLog');
Route::get('paywithpaypal', array('as' => 'paywithpaypal', 'uses' => 'MLMHomeController@payWithPaypal'));
Route::post('paypal', array('as' => 'paypal', 'uses' => 'MLMHomeController@postPaymentWithpaypal'));
Route::get('paypal', array('as' => 'status', 'uses' => 'MLMHomeController@getPaymentStatus'));
Route::get('payment_status', array('as' => 'payment_status', 'uses' => 'MLMHomeController@payWithPaypal_renewal'));
Route::post('paypal_renewal', array('as' => 'renewal_paypal', 'uses' => 'MLMHomeController@postPaymentWithpaypal_renewal'));
Route::get('paypal_renewal', array('as' => 'renewal_status', 'uses' => 'MLMHomeController@getPaymentStatus_renewal'));
Route::get('paypal_payment', array('as' => 'paypal_payment', 'uses' => 'MainController@payWithPaypal'));
Route::post('paypal_post', array('as' => 'paypal_post', 'uses' => 'MainController@postPaymentWithpaypal'));
Route::get('paypal_post', array('as' => 'paypal_status', 'uses' => 'MainController@getPaymentStatus'));
Route::post('test-jobs', 'MLMHomeController@run_jobs');
Route::post('get_street_info', 'MLMHomeController@get_street_info');
Route::post('add_enquiry_entry', 'MLMHomeController@add_enquiry_entry');
Route::post('update-stroke-time', 'MLMHomeController@update_user_stroke_time');
Route::post('update-idle-time', 'MLMHomeController@update_user_idle_time');
Route::post('update_video_watching', 'MLMHomeController@update_video_watching');
Route::get('general-setting', 'MLMAdminController@general_settings');
Route::get('affiliate_commission_setting', 'MLMAdminController@affiliate_commission_setting');
Route::post('update_affiliate_commission_setting', 'MLMAdminController@update_affiliate_commission_setting');
Route::post('update_general_setting', 'MLMAdminController@update_general_setting');
Route::post('update_affiliate_package', 'MLMAdminController@update_affiliate_package');
Route::post('update_level_income', 'MLMAdminController@update_level_income');
Route::get('plan/{id}', 'MLMAdminController@affiliate_package_update');
Route::get('level-income/{id}', 'MLMAdminController@level_income');
Route::post('update_prize_conditions', 'MLMAdminController@update_prize_conditions');
Route::get('admin/prize-conditions', 'MLMAdminController@prize_conditions');
Route::get('admin/prize-conditions/{id}', 'MLMAdminController@prize_conditions');
Route::post('update_other_conditions', 'MLMAdminController@update_other_conditions');
Route::get('admin/other-conditions', 'MLMAdminController@other_conditions');
Route::get('admin/other-conditions/{id}', 'MLMAdminController@other_conditions');
Route::post('update_bonus_conditions', 'MLMAdminController@update_bonus_conditions');
Route::get('admin/bonus-conditions', 'MLMAdminController@bonus_conditions');
Route::get('admin/bonus-conditions/{id}', 'MLMAdminController@bonus_conditions');
Route::get('admin/network', 'MLMAdminController@my_network');
Route::get('admin/level-income-report', 'MLMAdminController@level_income_report');
Route::get('admin/bonus-income-report', 'MLMAdminController@bonus_income_report');
Route::get('admin/prize-report', 'MLMAdminController@prize_report');
Route::get('admin/other-report', 'MLMAdminController@other_report');
Route::get('admin/transaction-history', 'MLMAdminController@transaction_history');
Route::post('/approve_test_component', 'MLMAdminController@approve_test_component');
Route::post('/deleteRow', 'MLMAdminController@deleteRow')->name('deleteRow');
Route::post('/view_lead_user', 'MLMAdminController@view_lead_user')->name('view_lead_user');
Route::post('/getchildtree', 'MLMAdminController@getchildtree')->name('getchildtree');
Route::post('/CheckSponser', 'MLMAdminController@CheckSponser')->name('CheckSponser');
Route::get('earning-point-setting', 'MLMAdminController@earning_point_setting');
Route::post('update_earning_point_setting', 'MLMAdminController@update_earning_point_setting');
Route::get('bonus-pool-price-list', 'MLMAdminController@bonus_pool_price_list');
Route::get('edit-bonus-pool-price/{id}', 'MLMAdminController@edit_bonus_pool_price');
//Route::get('pool-price-list', 'MLMAdminController@pool_price_list');
Route::post('edit_bonus_pool_price_post', 'MLMAdminController@edit_bonus_pool_price_post');
Route::get('affiliate-email-template', 'MLMAdminController@affiliate_email_templates');
Route::post('update_affiliate_template', 'MLMAdminController@update_affiliate_template');
Route::get('client-registration-email-template', 'MLMAdminController@client_registration_email_template');
Route::post('update_client_registration_email_template', 'MLMAdminController@update_client_registration_email_template');
Route::get('business-registration-email-template', 'MLMAdminController@business_registration_email_template');
Route::post('update_business_registration_email_template', 'MLMAdminController@update_business_registration_email_template');
Route::get('record-transactions-email-template', 'MLMAdminController@record_transactions_email_template');
Route::post('update_record_transactions_email_template', 'MLMAdminController@update_record_transactions_email_template');
Route::get('minus-balance-email-template', 'MLMAdminController@minus_balance_email_template');
Route::post('update_minus_balance_email_template', 'MLMAdminController@update_minus_balance_email_template');
Route::post('update_pool_prize_value', 'MLMAdminController@update_pool_prize_value');
Route::post('update_pool_other_value', 'MLMAdminController@update_pool_other_value');
Route::get('terms-conditions', 'MLMAdminController@terms_conditions');
Route::post('update_term_condition', 'MLMAdminController@update_term_condition');
Route::get('basket-rotation', 'MLMAdminController@basket_rotation_setting');
Route::get('basket-rotation/{id}', 'MLMAdminController@basket_rotation_setting');
Route::post('update_basket_rotation', 'MLMAdminController@update_basket_rotation');
Route::get('lead-qualifier-setting', 'MLMAdminController@lead_qualifier_setting');
Route::post('lead-qualifier-setting-update', 'MLMAdminController@lead_qualifier_setting_update');
Route::post('promotion-setting-update', 'MLMAdminController@promotion_setting_update');
Route::get('leads-by-category/{slug}', 'MLMAdminController@leads_by_category');
Route::get('basket-condition', 'MLMAdminController@basket_condition');
Route::get('basket-condition/{basket}', 'MLMAdminController@basket_condition')->name('basket-condition');
Route::get('basket-condition/{basket}/{id}', 'MLMAdminController@basket_condition')->name('basket-condition');
Route::post('update_assign_users_conditions', 'MLMAdminController@update_assign_users_conditions');
Route::post('update_basket_condition', 'MLMAdminController@update_basket_condition');
Route::post('manageBasketForm', 'MLMAdminController@manageBasketForm')->name('manageBasketForm');
Route::post('update_current_plan', 'MLMHomeController@update_current_plan');
Route::get('renew-plan/{id?}', 'MLMHomeController@upgrade_plan');
Route::get('back-office', 'MLMHomeController@back_office');
Route::post('UpdateChat', 'ChatController@UpdateChat')->name('UpdateChat');
Route::post('getChatusers', 'ChatController@getChatusers')->name('getChatusers');
Route::post('getAdminChatusers', 'ChatController@getAdminChatusers')->name('getAdminChatusers');
Route::post('showchat', 'ChatController@showchat')->name('showchat');
Route::post('msg_send_write_msg', 'ChatController@msg_send_write_msg')->name('msg_send_write_msg');
Route::post('search_user', 'ChatController@search_user')->name('search_user');
Route::post('DeleteChat', 'ChatController@DeleteChat')->name('DeleteChat');
Route::get('business-preview/{user_id}', 'MainController@business_preview');
Route::post('business_redirect_paypal', 'MainController@business_redirect_paypal');
Route::get('admin/tests_components', 'MLMAdminController@admin_tests_components');
Route::get('admin/promotion_condition/{id}', 'MLMAdminController@promotion_conditions');
Route::get('admin/tests_components/{id}', 'MLMAdminController@admin_tests_components');
Route::get('admin/forms_library', 'MLMAdminController@admin_forms_library');
Route::get('admin/forms_library/{id}', 'MLMAdminController@admin_forms_library');
Route::post('update_admin_forms_library', 'MLMAdminController@update_admin_forms_library');
Route::post('update_admin_tests_components', 'MLMAdminController@update_admin_tests_components');
Route::post('add_affiliate_library_form', 'MLMHomeController@add_affiliate_library_form');
Route::post('add_balancesheet_for_current_assets', 'MLMHomeController@add_balancesheet_for_current_assets');
Route::post('update_balancesheet_for_current_assets', 'MLMHomeController@update_balancesheet_for_current_assets');
Route::post('add_balancesheet_for_noncurrent_assets', 'MLMHomeController@add_balancesheet_for_noncurrent_assets');
Route::post('update_balancesheet_for_noncurrent_assets', 'MLMHomeController@update_balancesheet_for_noncurrent_assets');
Route::post('add_balancesheet_for_current_liability', 'MLMHomeController@add_balancesheet_for_current_liability');
Route::post('update_balancesheet_for_current_liability', 'MLMHomeController@update_balancesheet_for_current_liability');
Route::post('add_balancesheet_for_noncurrent_liability', 'MLMHomeController@add_balancesheet_for_noncurrent_liability');
Route::post('update_balancesheet_for_noncurrent_liability', 'MLMHomeController@update_balancesheet_for_noncurrent_liability');
Route::post('add_balancesheet_for_equity', 'MLMHomeController@add_balancesheet_for_equity');
Route::post('update_balancesheet_for_equity', 'MLMHomeController@update_balancesheet_for_equity');
Route::post('deleteRecord', 'LabController@deleteRowData')->name('deleteRecord');
Route::post('update_test_status', 'LabController@update_test_status')->name('update_test_status');
Route::post('update_lab_test_comment', 'LabController@update_lab_test_comment');
Route::post('get_ordered_test_info', 'LabController@get_ordered_test_info');
Route::post('get_completed_test_info', 'LabController@get_completed_test_info');
Route::post('mark-as-complete-test', 'LabController@mark_as_complete_test');
Route::post('mark-as-progress', 'LabController@mark_as_progress_test');
Route::post('pharmacy_form_submit', 'LabController@pharmacy_form_submit');
Route::post('add_new_complaint', 'LabController@add_new_complaint');
Route::post('add_new_component_by_user', 'LabController@add_new_component_by_user');
Route::post('get_standard_value', 'LabController@get_standard_value');
Route::post('add_new_medication', 'LabController@add_new_medication');
Route::post('add_new_recommendations', 'LabController@add_new_recommendations');
Route::get('download_file/{id}', 'LabController@download_file');
//Route::get('lab/client-lab-test','LabController@all_lab_test_page');
Route::get('lab/lab-test', 'LabController@lab_test_page');
Route::get('lab/lab-test/{id}', 'LabController@lab_test_page');
Route::get('upload-lab-test-result/{id}', 'LabController@upload_lab_test_result');
Route::get('lab/lab-test/{id}', 'LabController@lab_test_page');
Route::post('lab_test_add_edit_post', 'LabController@lab_test_add_edit');
Route::post('lab_test_upload_file', 'LabController@lab_test_upload_file');
Route::post('get_lab_test_for_laboratory', 'LabController@get_lab_test_for_laboratory');
Route::get('send_test_email', 'MLMHomeController@send_test_email');
Route::get('lab/referals', 'LabController@referals_page');
//Route::get('lab/vital-signs','LabController@vital_signs_page');
Route::get('lab/vital-signs/{id}', 'LabController@vital_signs_page');
Route::get('lab/vital-signs-edit/{id}/{uid}', 'LabController@vital_signs_update_page');
Route::get('lab/tests-comparision/{id}', 'LabController@test_comparision_page');
Route::get('lab/lab-report-chart/{client_id}/{component_id}', 'LabController@lab_report_chart');
Route::post('vital_signs_add_edit_post', 'LabController@vital_signs_add_edit_post');
Route::post('test_coparision_add_edit_post', 'LabController@test_coparision_add_edit_post');
Route::get('lab/visits', 'LabController@visits_page');
Route::get('lab/care-reminders', 'LabController@care_reminders_page');
Route::get('lab/access-role', 'LabController@access_role_page');
Route::get('lab/pharmacy/{id}', 'LabController@pharmacy_page');
Route::get('lab/pharmacy', 'LabController@pharmacy_page');
Route::get('lab/patient-grouping', 'LabController@patient_grouping_page');
Route::get('lab/resources', 'LabController@resources_page');
Route::post('get_survey_result', 'MainController@get_survey_result');

Route::get('admin/notification-cms', 'RoleController@notifications_cms');
Route::get('admin/notification-cms/{id}', 'RoleController@notifications_cms');
Route::post('add_edit_notification_cms', 'RoleController@add_edit_notification_cms');

Route::post('dashboardfoldercount', 'MainController@dashboardfoldercount');
Route::post('dashboardfoldercount_pre', 'MainController@dashboardfoldercount_pre');
Route::post('dashboardfoldercount_next', 'MainController@dashboardfoldercount_next');

Route::post('dashboardnewclientcount', 'MainController@dashboardnewclientcount');
Route::post('dashboardnewclientcount_pre', 'MainController@dashboardnewclientcount_pre');
Route::post('dashboardnewclientcount_next', 'MainController@dashboardnewclientcount_next');

Route::post('dashboardclientmgtcount', 'MainController@dashboardclientmgtcount');
Route::post('dashboardclientmgtcount_pre', 'MainController@dashboardclientmgtcount_pre');
Route::post('dashboardclientmgtcount_next', 'MainController@dashboardclientmgtcount_next');

Route::post('dashboardeventscount', 'MainController@dashboardeventscount');
Route::post('dashboardeventscount_pre', 'MainController@dashboardeventscount_pre');
Route::post('dashboardeventscount_next', 'MainController@dashboardeventscount_next');

Route::post('dashboardbirthdaycount', 'MainController@dashboardbirthdaycount');
Route::post('dashboardbirthdaycount_pre', 'MainController@dashboardbirthdaycount_pre');
Route::post('dashboardbirthdaycount_next', 'MainController@dashboardbirthdaycount_next');

Route::post('dashboardbalancecount', 'MainController@dashboardbalancecount');
Route::post('dashboardbalancecount_pre', 'MainController@dashboardbalancecount_pre');
Route::post('dashboardbalancecount_next', 'MainController@dashboardbalancecount_next');

Route::post('dashboardrevenue_recordscount', 'MainController@dashboardrevenue_recordscount');
Route::post('dashboardrevenue_recordscount_pre', 'MainController@dashboardrevenue_recordscount_pre');
Route::post('dashboardrevenue_recordscount_next', 'MainController@dashboardrevenue_recordscount_next');

Route::post('dashboardexpense_recordscount', 'MainController@dashboardexpense_recordscount');
Route::post('dashboardexpense_recordscount_pre', 'MainController@dashboardexpense_recordscount_pre');
Route::post('dashboardexpense_recordscount_next', 'MainController@dashboardexpense_recordscount_next');

Route::post('dashboardprofitlossscount', 'MainController@dashboardprofitlossscount');
Route::post('dashboardprofitlossscount_pre', 'MainController@dashboardprofitlossscount_pre');
Route::post('dashboardprofitlossscount_next', 'MainController@dashboardprofitlossscount_next');

Route::post('dashboardlabscount', 'MainController@dashboardlabscount');
Route::post('dashboardlabscount_pre', 'MainController@dashboardlabscount_pre');
Route::post('dashboardlabscount_next', 'MainController@dashboardlabscount_next');

Route::post('dashboardpharmacycount', 'MainController@dashboardpharmacycount');
Route::post('dashboardpharmacycount_pre', 'MainController@dashboardpharmacycount_pre');
Route::post('dashboardpharmacycount_next', 'MainController@dashboardpharmacycount_next');

Route::post('setGeoLocation', 'MainController@setGeoLocation');
Route::post('get_revenue_by_month_page', 'MainController@get_revenue_by_month_page');
Route::post('get_expense_by_month_page', 'MainController@get_expense_by_month_page');

Route::get('introduction_videos', 'LandingController@introduction_videos');
Route::get('introduction_videos/{user_id}/{code}/{language?}', 'LandingController@introduction_videos');

Route::get('testing', 'MLMHomeController@test_email');

Route::post('get_total_revenue_by_month', 'ArchiveController@total_revenue_by_month');
Route::post('get_total_expense_by_month', 'ArchiveController@total_expense_by_month');
Route::post('get_total_revenue_expense_by_month', 'ArchiveController@total_revenue_expense_by_month');
Route::post('get_quaterly_total_revenue', 'ArchiveController@get_quaterly_total_revenue');
Route::post('get_quaterly_total_expense', 'ArchiveController@get_quaterly_total_expense');
Route::post('get_qly_total_revenue_expense', 'ArchiveController@get_qly_total_revenue_expense');

// create by Marina
Route::get('create_budget_year', 'HomeController@create_budget_year');
Route::get('create_budget_quaterly_year', 'HomeController@create_budget_quaterly_year');
Route::get('tab2_year', 'HomeController@tab2_year');
Route::get('tab2_quaterly_year', 'HomeController@tab2_quaterly_year');
Route::get('tab3_year', 'HomeController@tab3_year');
Route::get('tab3_quaterly_year', 'HomeController@tab3_quaterly_year');
Route::get('tab4_year', 'HomeController@tab4_year');
Route::get('tab4_quaterly_year', 'HomeController@tab4_quaterly_year');
Route::get('tab5_year', 'HomeController@tab5_year');
Route::get('tab5_quaterly_year', 'HomeController@tab5_quaterly_year');

Route::get('create_projection_year', 'HomeController@create_projection_year');
Route::get('create_projection_quaterly_year', 'HomeController@create_projection_quaterly_year');
Route::get('tab22_year', 'HomeController@tab22_year');
Route::get('tab22_quaterly_year', 'HomeController@tab22_quaterly_year');
Route::get('tab33_year', 'HomeController@tab33_year');
Route::get('tab33_quaterly_year', 'HomeController@tab33_quaterly_year');
Route::get('tab44_year', 'HomeController@tab44_year');
Route::get('tab44_quaterly_year', 'HomeController@tab44_quaterly_year');
Route::get('tab55_year', 'HomeController@tab55_year');
Route::get('tab55_quaterly_year', 'HomeController@tab55_quaterly_year');

Route::get('fix-commission-setting', 'AdminController@fix_commission_setting');
Route::post('form-submit', 'AdminController@form_submit');
Route::get('select_department', 'MainController@select_department');
Route::get('select_arr', 'MainController@select_arr');
Route::get('select_school', 'MainController@select_school');

Route::get('profit_loss_stmt_weekly', 'FrontReportController@profit_loss_stmt_weekly');
Route::get('profit_loss_stmt_monthly', 'FrontReportController@profit_loss_stmt_monthly');
Route::get('profit_loss_stmt_quaterly', 'FrontReportController@profit_loss_stmt_yearly');
Route::get('revenue_report_monthly', 'FrontReportController@revenue_report_monthly');
Route::get('revenue_report_quaterly', 'FrontReportController@revenue_report_quaterly');
Route::get('expenses_report_monthly', 'FrontReportController@expenses_report_monthly');
Route::get('expenses_report_quaterly', 'FrontReportController@expenses_report_quaterly');
Route::get('balancesheet_report_yearly', 'FrontReportController@balancesheet_report_yearly');
Route::get('paymentbalance_report_monthly', 'FrontReportController@paymentbalance_report_monthly');
Route::get('paymentbalance_quaterly_report_quaterly', 'FrontReportController@paymentbalance_quaterly_report_quaterly');
Route::post('weekly-jobs', 'MLMHomeController@test_weekly_jobs');
Route::post('admin-manage-client-submit', 'MLMAdminController@manage_client_submit');
Route::post('admin-uncheckboxesmail', 'MLMAdminController@uncheckboxesmail');
Route::post('admin-uncheckedboxesmail', 'MLMAdminController@uncheckedboxesmail');
Route::post('admin-checkboxesmail', 'MLMAdminController@checkboxesmail');
Route::post('admin-checkboxesmail', 'MLMAdminController@checkboxesmail');
Route::post('admin_user_banner_details', 'MLMAdminController@admin_user_banner_details');

Route::post('affiliate_manage_client_send_on', 'MLMAdminController@admin_manage_client_send_on');
Route::post('affiliate_manage_client_card_submit', 'MLMAdminController@admin_manage_client_card_submit');
Route::post('affiliate_manage_client_card_send_on', 'MLMAdminController@admin_manage_client_card_send_on');
Route::post('affiliate_manage_client_card_send_with_reminder', 'MLMAdminController@_admin_manage_client_card_send_with_reminder');
Route::post('affiliate_manage_client_video_submit', 'MLMAdminController@admin_manage_client_video_submit');
Route::post('affiliate_manage_client_video_send_on', 'MLMAdminController@admin_manage_client_video_send_on');
Route::post('affiliate_manage_client_video_send_with_reminder', 'MLMAdminController@admin_manage_client_video_send_with_reminder');

Route::post('get_checked_email', 'AdminController@get_checked_email');
Route::post('un_checked_email', 'AdminController@un_checked_email');
Route::post('unchecked_email_boxes', 'AdminController@unchecked_email_boxes');
Route::post('admin_emmail_prev_details', 'AdminController@admin_emmail_prev_details');
Route::post('admin_title_wise_email', 'AdminController@admin_title_wise_email');
Route::post('admin_manage_client_send_with_reminder', 'MLMAdminController@admin_manage_client_send_with_reminder');
Route::get('blog', 'BlogController@index');
Route::get('blog_detail/{id}', 'BlogController@blog_detail');

Route::post('search_by_personal_info', 'SendSmsEmailController@search_by_personal_info');
Route::post('search_by', 'SendSmsEmailController@search_by');
Route::post('get_checked_mobile', 'SendSmsEmailController@get_checked_mobile');
Route::post('get_checked_box_mobile', 'SendSmsEmailController@get_checked_box_mobile');
Route::post('admin_send_sms', 'SendSmsEmailController@admin_send_sms');
Route::post('admin_send_sms_send_on', 'SendSmsEmailController@admin_send_sms_send_on');
Route::post('send_sms_with_reminder', 'SendSmsEmailController@send_sms_with_reminder');

Route::get('get_genealogy_user', 'ReportController@get_genealogy_users');
Route::get('get_genealogy_user_monthly', 'ReportController@get_genealogy_user_monthly');
Route::get('get_genealogy_user_quaterly', 'ReportController@get_genealogy_user_quaterly');
Route::get('get_genealogy_total_user', 'ReportController@get_genealogy_total_user');
Route::get('get_yearly_member', 'ReportController@get_yearly_member');
Route::get('get_monthly_member', 'ReportController@get_monthly_member');
Route::get('get_quarterly_member', 'ReportController@get_quarterly_member');

// marina

Route::post('get_checked_email', 'ReportController@get_checked_email');
Route::post('un_checked_email', 'ReportController@un_checked_email');
Route::post('unchecked_email_boxes', 'ReportController@unchecked_email_boxes');
Route::post('admin_emmail_prev_details', 'ReportController@admin_emmail_prev_details');
Route::post('admin_title_wise_email', 'ReportController@admin_title_wise_email');

Route::post('admin_manage_client_submit', 'ReportController@manage_client_submit');
Route::post('admin_manage_client_send_with_reminder', 'ReportController@manage_client_send_with_reminder');
Route::post('admin_user_banner_details', 'ReportController@admin_user_banner_details');
Route::post('admin_manage_client_send_on', 'ReportController@manage_client_send_on');
Route::post('admin_manage_client_card_send_with_reminder', 'ReportController@manage_client_card_send_with_reminder');
Route::post('admin_manage_client_card_send_on', 'ReportController@manage_client_card_send_on');
Route::post('admin_manage_client_card_submit', 'ReportController@manage_client_card_submit');
Route::post('admin_manage_client_video_submit', 'ReportController@manage_client_video_submit');
Route::post('admin_manage_client_video_send_with_reminder', 'ReportController@manage_client_video_send_with_reminder');
Route::post('admin_manage_client_video_send_on', 'ReportController@manage_client_video_send_on');

Route::post('get_genealogyfilter_data', 'ReportController@get_genealogyfilter_data');

Route::get('client-report-view', 'HomeController@client_report_view');
Route::post('get_reports_result', 'HomeController@get_reports_result');

Route::post('discount', 'DiscountController@store')->name('discount');
Route::post('discount_update', 'DiscountController@update')->name('discount_update');
Route::post('find', 'DiscountController@phone')->name('find');
Route::post('discount_apply', 'DiscountController@discount_apply')->name('discount_apply');

Route::get('projection_setup', 'MainController@projection_setup');
Route::post('monthlylistfinance1', 'MainController@monthlylistfinance1');

Route::post('apply_on_acc', 'DiscountController@apply_on_acc');
Route::post('email_invoice', 'DiscountController@email_invoice');

// software developer Ravi coding start 9660813935
Route::get('deduct-commission-amount', 'MLMHomeController@deduct_commission_amount');
Route::get('country-status-setting', 'MLMAdminController@country_status_setting');
Route::post('add-country-status-setting', 'MLMAdminController@add_country_status_setting');
Route::get('update-country-status-setting/{id}', 'MLMAdminController@country_status_setting');
Route::get('deduct-affiliate-commission', 'MLMAdminController@deduct_affiliate_commission');
Route::post('add-country-status-setting-message', 'MLMAdminController@add_country_status_setting_message');
Route::get('verify_country_code/{code?}', 'MLMHomeController@verify_country_code');
Route::get('plan-expire-popup/{code?}', 'AdminController@plan_expire_popup');
Route::post('add-plan-expire-popup-message', 'AdminController@add_plan_expire_popup_message');
//Mohsin work
Route::get('create-free-registration','MLMAdminController@create_free_registration');
Route::post('add-free-registration','MLMAdminController@add_free_registration');
Route::get('registration_status_change','MLMAdminController@statusChange');
Route::get('free-reg-delete/{id}','MLMAdminController@freeRegDelete');

Route::get('birth_delete/{id}', 'MLMAdminController@birthDelete');
Route::get('add_faith_religious', 'MLMAdminController@add_faith_religious');
Route::get('birth_edit/{id}', 'MLMAdminController@birthEdit');
Route::get('birth_update', 'MLMAdminController@birthUpdate');
Route::get('mafama-support', 'MLMAdminController@createMafamaSupport');
Route::get('mafama-edit/{id}', 'MLMAdminController@editMafamaSupport');
Route::post('update-mafama-support', 'MLMAdminController@updateMafamaSupport');
Route::post('store-mafama-support', 'MLMAdminController@storeMafamaSupport');

// Admin Routes for Birthday - City Projects Settings
Route::get('admin_birthplace', 'AdminController@admin_birthplace')->name('admin_birthplace');
Route::post('add_admin_birthplace_details', 'AdminController@add_admin_birthplace_details')->name('add_admin_birthplace_details');
Route::post('update_admin_birthplace_details_headings', 'AdminController@update_admin_birthplace_details_headings')->name('update_admin_birthplace_details_headings');
Route::post('delete_admin_birthplace_details', 'AdminController@delete_admin_birthplace_details')->name('delete_admin_birthplace_details');
Route::get('edit_admin_birthplace_details/{id}', 'AdminController@edit_admin_birthplace_details')->name('edit_admin_birthplace_details');

// Admin Routes for Arts and culture Settings
Route::get('admin_arts_and_culture', 'AdminController@admin_arts_and_culture')->name('admin_arts_and_culture');
Route::post('add_admin_arts_and_culture', 'AdminController@add_admin_arts_and_culture')->name('add_admin_arts_and_culture');
Route::get('edit_admin_arts_and_culture/{id}', 'AdminController@edit_admin_arts_and_culture')->name('edit_admin_arts_and_culture');
Route::post('delete_admin_arts_and_culture', 'AdminController@delete_admin_arts_and_culture')->name('delete_admin_arts_and_culture');
Route::post('update_admin_arts_and_culture', 'AdminController@update_admin_arts_and_culture')->name('update_admin_arts_and_culture');
// Admin Routes for Arts and culture Settings End Here
// Frontend Routes for Arts and culture Settings
Route::get('setting_art_and_culture', 'HomeController@setting_art_and_culture')->name('setting_art_and_culture');
// Frontend Routes for Arts and culture Settings End Here

// Admin Routes for Top City News Settings
Route::get('admin_top_city_news', 'AdminController@admin_top_city_news')->name('admin_top_city_news');
Route::post('add_admin_top_city_news', 'AdminController@add_admin_top_city_news')->name('add_admin_top_city_news');
Route::get('edit_admin_top_city_news/{id}', 'AdminController@edit_admin_top_city_news')->name('edit_admin_top_city_news');
Route::post('delete_admin_top_city_news', 'AdminController@delete_admin_top_city_news')->name('delete_admin_top_city_news');
Route::post('update_admin_top_city_news', 'AdminController@update_admin_top_city_news')->name('update_admin_top_city_news');
// Admin Routes for Top City News Settings End Here

// Admin Routes for My Faith Settings
Route::get('admin_my_faith', 'AdminController@admin_my_faith')->name('admin_my_faith');
Route::post('add_admin_my_faith', 'AdminController@add_admin_my_faith')->name('add_admin_my_faith');
Route::get('edit_admin_my_faith/{id}', 'AdminController@edit_admin_my_faith')->name('edit_admin_my_faith');
Route::post('delete_admin_my_faith', 'AdminController@delete_admin_my_faith')->name('delete_admin_my_faith');
Route::post('update_admin_my_faith', 'AdminController@update_admin_my_faith')->name('update_admin_my_faith');
// Admin Routes for My Faith Settings End Here

Route::get('setting_birthplace', 'HomeController@setting_birthplace')->name('setting_birthplace');

// Admin Routes for Home Page - Transactions
Route::get('admin/setting/transaction', 'AdminController@transactions')->name('transactions');
Route::post('update_admin_transactions', 'AdminController@update_admin_transactions')->name('update_admin_transactions');
// Admin Routes for Home Page - Transactions End Here

// Admin Routes for Leaders Board Settings
Route::get('admin/leadersboard', 'AdminController@leadersboard')->name('leadersboard');
Route::get('admin/user_leadersboard', 'AdminController@user_leadersboard')->name('user_leadersboard');
Route::post('admin/add/leadersboard', 'AdminController@add_leadersboard')->name('add_leadersboard');
Route::post('admin/setting/leadersboard', 'AdminController@update_leadersboard_setting')->name('update_leadersboard_setting');
Route::get('admin/edit/leadersboard/{id}', 'AdminController@edit_leadersboard')->name('edit_leadersboard');
Route::post('delete_leader_board', 'AdminController@delete_leader_board')->name('delete_leader_board');
Route::post('update_leadersboard', 'AdminController@update_leadersboard')->name('update_leadersboard');
Route::post('update_user_leader_board', 'HomeController@update_user_leader_board')->name('update_user_leader_board');
Route::post('delete_user_leader_board', 'AdminController@delete_user_leader_board')->name('delete_user_leader_board');
Route::post('approve_user_leader_board', 'AdminController@approve_user_leader_board')->name('approve_user_leader_board');
Route::get('leaders_board', 'HomeController@leaders_board')->name('leaders_board');
Route::get('leaders_board_details/{id}', 'HomeController@leaders_board_details')->name('leaders_board_details');
Route::get('leaders_board_details', 'HomeController@leaders_board_details')->name('leaders_board_details');
// Admin Routes for Leaders Board Settings End Here

// Home pages routes for Settings
Route::get('art-and-culture', 'HomeController@art_and_culture')->name('art_and_culture');
Route::post('add_user_arts_and_culture', 'HomeController@add_user_arts_and_culture')->name('add_user_arts_and_culture');
Route::post('delete_user_arts_and_culture', 'HomeController@delete_user_arts_and_culture')->name('delete_user_arts_and_culture');
Route::get('edit_user_arts_and_culture/{id}', 'HomeController@edit_user_arts_and_culture')->name('edit_user_arts_and_culture');
// Home pages routes for Settings End here

// Home pages routes for Settings Top City News
Route::get('setting_top_city_news', 'HomeController@setting_top_city_news')->name('setting_top_city_news');
Route::get('top_city_news', 'HomeController@top_city_news')->name('top_city_news');
Route::post('add_user_top_city_news', 'HomeController@add_user_top_city_news')->name('add_user_top_city_news');
Route::post('delete_user_top_city_news', 'HomeController@delete_user_top_city_news')->name('delete_user_top_city_news');
Route::get('edit_user_top_city_news/{id}', 'HomeController@edit_user_top_city_news')->name('edit_user_top_city_news');
// Home pages routes for Settings Top City News End here



// Home pages routes for Settings My Faith
Route::get('setting_my_faith', 'HomeController@setting_my_faith')->name('setting_my_faith');
Route::get('my_faith', 'HomeController@my_faith')->name('my_faith');
Route::post('add_user_my_faith', 'HomeController@add_user_my_faith')->name('add_user_my_faith');
Route::post('delete_user_my_faith', 'HomeController@delete_user_my_faith')->name('delete_user_my_faith');
Route::get('edit_user_my_faith/{id}', 'HomeController@edit_user_my_faith')->name('edit_user_my_faith');
// Home pages routes for Settings My Faith End here


// Institutions Routes
Route::match(array('GET', 'POST'),'admin_school', 'AdminController@admin_school');
// Route::match(array('GET', 'POST'),'edit_school', 'AdminController@edit_school');
Route::get('edit_school/{id}', 'AdminController@edit_school');
Route::get('delete_school/{id}', 'AdminController@delete_school');
Route::post('update_institute_status', 'AdminController@update_institute_status');
